package ${package}.controller;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.process.constant.ProcessConstant;
import com.manatee.process.util.ProcessCheckUtil;
import com.manatee.process.util.StringUtil;
import com.manatee.source.demo.conf.ProjectConf;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.manatee.process.domain.ProcessContent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

import ${package}.service.${upClassName}Service;

/**
* ${moduleName}控制器
*
* @author ${author} ${email}
* @since ${version} ${date}
*/
@RestController
@AllArgsConstructor
public class ${upClassName}Controller {
    @Autowired
    private ${upClassName}Service ${className}Service;

<#list moduleList as module>
    @CrossOrigin(origins = "*")
    <#if module.requestMode == "GET">
    @GetMapping("${basePath}${module.projectId}/${module.moduleCode}")
    </#if>
    <#if module.requestMode == "POST">
    @PostMapping("${basePath}${module.projectId}/${module.moduleCode}")
    </#if>
    @ApiOperation("${module.moduleName}")
    public JSONObject ${module.moduleCode}(HttpServletRequest request, HttpServletResponse response<#if module.requestMode == "GET">)throws BizException {</#if>
        <#if module.requestMode == "POST">,@RequestBody(required = false) JSONObject data) throws BizException{</#if>
        String code = "${module.moduleCode}";
        Long projectId = ${module.projectId}L;
        ProcessContent content = new ProcessContent();
        initParam(content,request);
        <#if module.requestMode == "POST">
        content.putRequest(data);
        </#if>
        content.putTempContent(ProcessConstant.Key.CODE, code);
        content.putTempContent(ProcessConstant.Key.PROJECT_ID, projectId);

        JSONObject result = ${className}Service.${module.moduleCode}Process(content);
        boolean committed = response.isCommitted();
        return committed?null:result;
    }

</#list>

    private void initParam(ProcessContent content, HttpServletRequest request){
        content.putTempContent("userId", 2);
        Map<String,String[]> params = request.getParameterMap();
        for(Map.Entry<String,String[]> aMap:params.entrySet()){
            String key = aMap.getKey();
            if(ProcessCheckUtil.isKeyWord(key)){
                continue;
            }
            String[] value = aMap.getValue();
            if(value == null && value.length==0){
                continue;
            }
            Object aValue = null;
            if (value.length == 1) {
                aValue = value[0];
            } else {
                aValue = Arrays.asList((Object [])value);
            }
            content.putRequest(key,aValue);
        }
        Enumeration<String> headers = request.getHeaderNames();
        while (headers.hasMoreElements()){
            String headKey = headers.nextElement();
            String headValue = request.getHeader(headKey);
            if(StringUtil.isNotBlank(headValue)){
                content.putHeader(headKey,headValue);
            }
        }

        if (StringUtil.isNotBlank(ProjectConf.projectConf)) {
            content.setProjectConf(JSONObject.parseObject(ProjectConf.projectConf));
        }
    }
}