/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.MDC;

public class ProcessParamUtil {
    private static final AtomicLong ID_OFF_SET = new AtomicLong(1L);
    private static long TIME = 1L;

    public static synchronized void initTraceId(ProcessContent content) {
        long time;
        Long userId;
        String traceId = content.getTraceId();
        if (StringUtil.isNotBlank(traceId)) {
            return;
        }
        traceId = (String)content.getRequest("traceId");
        if (StringUtil.isNotBlank(traceId)) {
            MDC.put((String)"traceId", (String)traceId);
            content.setTraceId(traceId);
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (ProcessParamUtil.isDebug(content)) {
            sb.append("D-");
        }
        if ((userId = content.getUserId()) != null) {
            sb.append(userId).append("-");
        }
        if (TIME < (time = System.currentTimeMillis())) {
            TIME = time;
            ID_OFF_SET.set(1L);
        }
        long traceIdLong = time * 1000L + ID_OFF_SET.getAndIncrement();
        sb.append(traceIdLong);
        content.setTraceId(sb.toString());
        MDC.put((String)"traceId", (String)sb.toString());
    }

    public static boolean isDebug(ProcessContent content) {
        Object debug = content.getTempContent("debug");
        if (debug == null) {
            return false;
        }
        Object debugInterrupt = content.getTempContent("debugInterrupt");
        return debugInterrupt == null;
    }

    public static String getParam(ProcessContent content, String key) throws BizException {
        String conf = (String)content.getStepConf(key);
        if (StringUtil.isBlank(conf)) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, key + "_is_null");
        }
        return conf;
    }

    public static Object getRequestData(ProcessContent content, String key) throws BizException {
        Object value = content.getRequestSubValue(key);
        if (value == null) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, key + "_is_null");
        }
        return value;
    }
}

