/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.util;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.util.Set;

public class BooleanUtil {
    private static final Set<String> TRUE_SET = CollUtil.newHashSet("true", "yes", "y", "t", "ok", "1", "on", "\u662f", "\u5bf9", "\u771f", "\u5c0d", "\u221a");

    public static Boolean negate(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean negate(boolean bool) {
        return !bool;
    }

    public static boolean toBoolean(String valueStr) {
        if (StrUtil.isNotBlank(valueStr)) {
            valueStr = valueStr.trim().toLowerCase();
            return TRUE_SET.contains(valueStr);
        }
        return false;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer toInteger(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)BooleanUtil.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(BooleanUtil.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)BooleanUtil.toInt(value);
    }

    public static Byte toByteObj(boolean value) {
        return BooleanUtil.toByte(value);
    }

    public static long toLong(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Long toLongObj(boolean value) {
        return BooleanUtil.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)BooleanUtil.toInt(value);
    }

    public static Short toShortObj(boolean value) {
        return BooleanUtil.toShort(value);
    }

    public static float toFloat(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Float toFloatObj(boolean value) {
        return Float.valueOf(BooleanUtil.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Double toDoubleObj(boolean value) {
        return BooleanUtil.toDouble(value);
    }

    public static String toStringTrueFalse(boolean bool) {
        return BooleanUtil.toString(bool, "true", "false");
    }

    public static String toStringOnOff(boolean bool) {
        return BooleanUtil.toString(bool, "on", "off");
    }

    public static String toStringYesNo(boolean bool) {
        return BooleanUtil.toString(bool, "yes", "no");
    }

    public static String toString(boolean bool, String trueString, String falseString) {
        return bool ? trueString : falseString;
    }

    public static boolean and(boolean ... array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (element) continue;
            return false;
        }
        return true;
    }

    public static Boolean andOfWrap(Boolean ... array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanUtil.and(primitive);
    }

    public static boolean or(boolean ... array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public static Boolean orOfWrap(Boolean ... array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanUtil.or(primitive);
    }

    public static boolean xor(boolean ... array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean result = false;
        for (boolean element : array) {
            result ^= element;
        }
        return result;
    }

    public static Boolean xorOfWrap(Boolean ... array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanUtil.xor(primitive);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }
}

