/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.compiler;

import com.manatee.common.util.tool.core.compiler.CompilerException;
import com.manatee.common.util.tool.core.compiler.CompilerUtil;
import com.manatee.common.util.tool.core.compiler.DiagnosticUtil;
import com.manatee.common.util.tool.core.compiler.JavaClassFileManager;
import com.manatee.common.util.tool.core.compiler.JavaFileObjectUtil;
import com.manatee.common.util.tool.core.compiler.JavaSourceFileObject;
import com.manatee.common.util.tool.core.io.FileUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.io.resource.FileResource;
import com.manatee.common.util.tool.core.io.resource.Resource;
import com.manatee.common.util.tool.core.io.resource.StringResource;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.ClassLoaderUtil;
import com.manatee.common.util.tool.core.util.ObjectUtil;
import com.manatee.common.util.tool.core.util.URLUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaSourceCompiler {
    private final List<Resource> sourceList = new ArrayList<Resource>();
    private final List<File> libraryFileList = new ArrayList<File>();
    private final ClassLoader parentClassLoader;

    public static JavaSourceCompiler create(ClassLoader parent) {
        return new JavaSourceCompiler(parent);
    }

    private JavaSourceCompiler(ClassLoader parent) {
        this.parentClassLoader = ObjectUtil.defaultIfNull(parent, ClassLoaderUtil.getClassLoader());
    }

    public JavaSourceCompiler addSource(Resource ... resources) {
        if (ArrayUtil.isNotEmpty(resources)) {
            this.sourceList.addAll(Arrays.asList(resources));
        }
        return this;
    }

    public JavaSourceCompiler addSource(File ... files) {
        if (ArrayUtil.isNotEmpty(files)) {
            for (File file : files) {
                this.sourceList.add(new FileResource(file));
            }
        }
        return this;
    }

    public JavaSourceCompiler addSource(Map<String, String> sourceCodeMap) {
        if (MapUtil.isNotEmpty(sourceCodeMap)) {
            sourceCodeMap.forEach(this::addSource);
        }
        return this;
    }

    public JavaSourceCompiler addSource(String className, String sourceCode) {
        if (className != null && sourceCode != null) {
            this.sourceList.add(new StringResource(sourceCode, className));
        }
        return this;
    }

    public JavaSourceCompiler addLibrary(File ... files) {
        if (ArrayUtil.isNotEmpty(files)) {
            this.libraryFileList.addAll(Arrays.asList(files));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader compile() {
        List<File> classPath = this.getClassPath();
        URL[] urLs = URLUtil.getURLs(classPath.toArray(new File[0]));
        URLClassLoader ucl = URLClassLoader.newInstance(urLs, this.parentClassLoader);
        if (this.sourceList.isEmpty()) {
            return ucl;
        }
        JavaClassFileManager javaFileManager = new JavaClassFileManager(ucl, CompilerUtil.getFileManager());
        ArrayList<String> options = new ArrayList<String>();
        if (!classPath.isEmpty()) {
            List cp = classPath.stream().map(File::getAbsolutePath).collect(Collectors.toList());
            options.add("-cp");
            options.addAll(cp);
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        List<JavaFileObject> javaFileObjectList = this.getJavaFileObject();
        JavaCompiler.CompilationTask task = CompilerUtil.getTask(javaFileManager, diagnosticCollector, options, javaFileObjectList);
        try {
            if (task.call().booleanValue()) {
                ClassLoader classLoader = javaFileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
                return classLoader;
            }
        }
        finally {
            IoUtil.close(javaFileManager);
        }
        throw new CompilerException(DiagnosticUtil.getMessages(diagnosticCollector));
    }

    private List<File> getClassPath() {
        ArrayList<File> classPathFileList = new ArrayList<File>();
        for (File file : this.libraryFileList) {
            List<File> jarOrZipFile = FileUtil.loopFiles(file, subFile -> JavaFileObjectUtil.isJarOrZipFile(subFile.getName()));
            classPathFileList.addAll(jarOrZipFile);
            if (!file.isDirectory()) continue;
            classPathFileList.add(file);
        }
        return classPathFileList;
    }

    private List<JavaFileObject> getJavaFileObject() {
        ArrayList<JavaFileObject> list = new ArrayList<JavaFileObject>();
        for (Resource resource : this.sourceList) {
            if (resource instanceof FileResource) {
                File file = ((FileResource)resource).getFile();
                FileUtil.walkFiles(file, subFile -> list.addAll(JavaFileObjectUtil.getJavaFileObjects(file)));
                continue;
            }
            list.add(new JavaSourceFileObject(resource.getName(), resource.getStream()));
        }
        return list;
    }

    private Collection<JavaFileObject> getJavaFileObjectByMap(Map<String, String> sourceCodeMap) {
        if (MapUtil.isNotEmpty(sourceCodeMap)) {
            return sourceCodeMap.entrySet().stream().map(entry -> new JavaSourceFileObject((String)entry.getKey(), (String)entry.getValue(), CharsetUtil.CHARSET_UTF_8)).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }

    private JavaFileObject getJavaFileObjectByJavaFile(File file) {
        return new JavaSourceFileObject(file.toURI());
    }
}

