/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.domain;

import java.io.Serializable;

public enum ResultCode implements Cloneable,
Serializable
{
    SUCCESS(0, "success", "\u8bf7\u6c42\u6210\u529f"),
    ALREADY_HAVE(-1, "already_have", "\u6570\u636e\u5df2\u5b58\u5728"),
    RESULT_IS_NULL(-2, "result_is_null", "\u6570\u636e\u4e3a\u7a7a"),
    NOT_LOGIN(-10, "not_login", "\u672a\u767b\u5f55"),
    SYSTEM_ERROR(-20, "system_error", "\u7cfb\u7edf\u9519\u8bef"),
    PARAM_IS_ERROR(-30, "param_is_error", "\u53c2\u6570\u9519\u8bef"),
    BIZ_ERROR(-40, "biz_error", "\u4e1a\u52a1\u9519\u8bef"),
    CONF_ERROR(-50, "conf_error", "\u914d\u7f6e\u9519\u8bef"),
    NOT_AUTHORIZED(-70, "not_authorized", "\u672a\u6388\u6743"),
    NO_LICENSE(-80, "no_license", "\u6ca1\u6709license"),
    NOT_COMMERCIAL_VERSION(-90, "not_commercial_version", "\u975e\u5546\u4e1a\u7248\u672c"),
    METHOD_NOT_ALLOWED(-100, "method_not_allowed", "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u88ab\u5141\u8bb8"),
    SERVICE_IS_ERROR(-110, "service_is_error", "\u5f15\u64ce\u670d\u52a1\u5f02\u5e38");

    private static final long serialVersionUID = -4532521073602449709L;
    private int id;
    private String code;
    private String subCode;
    private String msg;
    private String traceId;
    private Integer interrupt;

    private ResultCode() {
    }

    private ResultCode(int id, String code, String msg) {
        this.id = id;
        this.code = code;
        this.msg = msg;
    }

    private ResultCode(ResultCode resultCode) {
        this.id = resultCode.getId();
        this.code = resultCode.getCode();
    }

    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean isSuccess() {
        return this.id >= 0;
    }

    public String getSubCode() {
        return this.subCode;
    }

    public Integer getInterrupt() {
        return this.interrupt;
    }

    public String getMsg() {
        return this.msg;
    }

    public static ResultCode getResultCode(String codeStr) {
        for (ResultCode code : ResultCode.values()) {
            if (!code.getCode().equals(codeStr)) continue;
            return code;
        }
        return BIZ_ERROR;
    }

    public static Boolean exist(String codeStr) {
        for (ResultCode code : ResultCode.values()) {
            if (!code.getCode().equals(codeStr)) continue;
            return true;
        }
        return false;
    }

    public static int getStatus(String code, String subCode) {
        if (PARAM_IS_ERROR.getCode().equals(code)) {
            return 400;
        }
        if (NOT_AUTHORIZED.getCode().equals(code)) {
            return 401;
        }
        if ("process_not_found".equals(subCode)) {
            return 404;
        }
        if (METHOD_NOT_ALLOWED.getCode().equals(code)) {
            return 405;
        }
        if (SYSTEM_ERROR.getCode().equals(code)) {
            return 500;
        }
        if (BIZ_ERROR.getCode().equals(code)) {
            return 500;
        }
        if (CONF_ERROR.getCode().equals(code)) {
            return 510;
        }
        return 200;
    }
}

