/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.seata.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import io.seata.core.exception.TransactionException;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SeataTransactionProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(SeataTransactionProcess.class);
    @Resource
    private ProcessChain processChain;
    @Resource
    private ProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"steps"});
        JSONObject conf = content.getStepConf();
        GlobalTransaction tx = GlobalTransactionContext.getCurrentOrCreate();
        try {
            tx.begin(60000);
            this.doSteps(content, conf);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                this.log.warn("\u53d1\u751f\u5f02\u5e38\uff0cseata\u4e8b\u52a1\u56de\u6eda");
                tx.rollback();
            }
            catch (TransactionException throwables) {
                throwables.printStackTrace();
            }
            if (e instanceof BizException) {
                BizException bizException = (BizException)e;
                throw bizException;
            }
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, "cal_seataTransactionProcess_error", e);
            String id = conf.getString("id");
            String title = conf.getString("title");
            bizException.setId(id);
            bizException.setStepName("seataTransactionProcess");
            bizException.setStepTitle(title);
            throw bizException;
        }
    }

    private void doSteps(ProcessContent content, JSONObject conf) throws BizException {
        List steps = ProcessDataSource.formatSteps((JSONObject)conf);
        this.processChain.executeSteps(content, steps);
    }

    public String getName() {
        return "seataTransactionProcess";
    }
}

