/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.collection.ListUtil;
import com.manatee.common.util.tool.core.date.DateUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.IdentityLink;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryHistoricTaskProcess
implements IProcess {
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        String processInstanceId = this.variableUtil.calVarInConf(content, "processInstanceId");
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        if (StrUtil.isNotBlank((CharSequence)processInstanceId)) {
            historicTaskInstanceQuery.processInstanceId(processInstanceId);
        }
        List list = historicTaskInstanceQuery.list();
        CollUtil.sort((List)list, (o1, o2) -> {
            int startComparison;
            if (o1.getStartTime() == null && o2.getStartTime() == null) {
                if (o1.getEndTime() == null && o2.getEndTime() == null) {
                    return 0;
                }
                if (o1.getEndTime() == null) {
                    return 0;
                }
                if (o2.getEndTime() == null) {
                    return 1;
                }
            }
            if ((startComparison = o2.getStartTime().compareTo(o1.getStartTime())) != 0) {
                return startComparison;
            }
            if (o1.getEndTime() == null && o2.getEndTime() == null) {
                return 0;
            }
            if (o1.getEndTime() == null) {
                return 0;
            }
            if (o2.getEndTime() == null) {
                return 1;
            }
            return o2.getEndTime().compareTo(o1.getEndTime());
        });
        String jsonString = JSONUtil.toJsonStr((Object)list);
        JSONArray objects = JSONArray.parseArray((String)jsonString);
        block0: for (int i = 0; i < objects.size(); ++i) {
            List variableNames;
            Map variablesLocal;
            List groups;
            String endTime;
            JSONObject jsonObject = objects.getJSONObject(i);
            String id = jsonObject.getString("id");
            List taskComments = this.taskService.getTaskComments(id);
            if (CollUtil.isNotEmpty((Collection)taskComments)) {
                Comment comment = (Comment)taskComments.get(0);
                jsonObject.put("fullMessage", (Object)comment.getFullMessage());
            }
            if (StrUtil.isNotBlank((CharSequence)(endTime = jsonObject.getString("endTime")))) {
                groups = this.historyService.createHistoricIdentityLinkLogQuery().taskId(id).list();
                if (!CollUtil.isNotEmpty((Collection)groups)) continue;
                for (IdentityLink group : groups) {
                    if (!"candidate".equals(group.getType())) continue;
                    jsonObject.put("groupId", (Object)group.getGroupId());
                    continue block0;
                }
                continue;
            }
            groups = this.taskService.getIdentityLinksForTask(id);
            if (CollUtil.isNotEmpty((Collection)groups)) {
                for (IdentityLink group : groups) {
                    if (!"candidate".equals(group.getType())) continue;
                    jsonObject.put("groupId", (Object)group.getGroupId());
                    break;
                }
            }
            if ((variablesLocal = this.taskService.getVariablesLocal(id, (Collection)(variableNames = ListUtil.list((boolean)false, (Object[])new String[]{"MANATEE_FULL_MSG", "MANATEE_TASK_END_TIME"})))) == null || variablesLocal.size() <= 0) continue;
            String msg = (String)variablesLocal.get("MANATEE_FULL_MSG");
            endTime = (String)variablesLocal.get("MANATEE_TASK_END_TIME");
            jsonObject.put("fullMessage", (Object)msg);
            jsonObject.put("endTime", (Object)DateUtil.parse((CharSequence)endTime).getTime());
            jsonObject.put("deleteReason", (Object)"completed");
            objects.set(i, (Object)jsonObject);
        }
        this.outputUtil.putData(content, (Object)objects);
    }

    public String getName() {
        return "camundaQueryHistoricTaskProcess";
    }
}

