/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.repository;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.springframework.stereotype.Service;

@Service
public class CamundaCreateDeploymentProcess
implements IProcess {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        String bpmn = this.variableUtil.calVarInConf(content, "processBpmn");
        String png = this.variableUtil.calVarInConf(content, "processBpmnPic");
        String name = this.variableUtil.calVarInConf(content, "processBpmnName");
        String tenantId = this.variableUtil.calVarInConf(content, "processTenantId");
        try {
            DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addString("manatee.bpmn", bpmn).addString("manatee.png", png).name(name);
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                deploymentBuilder.tenantId(tenantId);
            }
            Deployment deploy = deploymentBuilder.deploy();
            this.outputUtil.putData(content, (Object)deploy.getId());
        }
        catch (ParseException e) {
            throw new BizException(ResultCode.CONF_ERROR, "\u89e3\u6790\u6d41\u7a0b\u56fe\u5931\u8d25" + e.getMessage());
        }
    }

    public String getName() {
        return "camundaCreateDeploymentProcess";
    }
}

