/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.idgenerator;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.config.camunda.IdGenerator;
import com.manatee.lowcode.domain.ModularityRequest;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import javax.annotation.Resource;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class CustomUuidGenerator
implements org.camunda.bpm.engine.impl.cfg.IdGenerator {
    @Resource
    private ManateeConfig manateeConfig;
    @Resource
    private ModularityManager modularityManager;
    protected static TimeBasedGenerator timeBasedGenerator;

    public CustomUuidGenerator() {
        this.ensureGeneratorInitialized();
    }

    public String getNextId() {
        return this.getId();
    }

    private String getId() {
        IdGenerator idGenerator = this.manateeConfig.getCamunda().getIdGenerator();
        if (StrUtil.isBlank((CharSequence)idGenerator.getModuleCode())) {
            return timeBasedGenerator.generate().toString();
        }
        ModularityRequest modularityRequest = new ModularityRequest();
        modularityRequest.setProjectId(idGenerator.getProjectId());
        modularityRequest.setCode(idGenerator.getModuleCode());
        String traceId = MDC.get((String)"traceId");
        modularityRequest.setTraceId(traceId);
        ModularityResult modularityResult = this.modularityManager.executionModule(modularityRequest);
        if (modularityResult.isSuccess() && modularityResult.getData() != null && modularityResult.getData().get("id") != null) {
            return modularityResult.getData().get("id").toString();
        }
        return timeBasedGenerator.generate().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ensureGeneratorInitialized() {
        if (timeBasedGenerator != null) return;
        Class<StrongUuidGenerator> clazz = StrongUuidGenerator.class;
        synchronized (StrongUuidGenerator.class) {
            if (timeBasedGenerator != null) return;
            timeBasedGenerator = Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.fromInterface());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

