/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.elasticsearch.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CamelCaseUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.elasticsearch.domain.ESQuery;
import com.manatee.elasticsearch.manager.ESManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchQueryProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private ESManager esManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"index"});
        ESQuery esQuery = this.esManager.getESQuery(content);
        SearchRequest searchRequest = this.esManager.getSearchRequest(esQuery);
        SearchResponse searchResponse = this.esManager.getSearchResponse(searchRequest);
        JSON result = this.getResult(searchResponse, esQuery);
        this.outputUtil.handleAndPutData(content, (Object)result);
        JSONObject totalCountJson = this.getTotalCount(searchResponse, content, esQuery);
        if (totalCountJson != null) {
            this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
        }
    }

    private JSON getResult(SearchResponse searchResponse, ESQuery esQuery) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            Map sourceAsMap = hit.getSourceAsMap();
            JSONObject hitJosn = new JSONObject(sourceAsMap);
            hitJosn.put("id", (Object)hit.getId());
            list.add(hitJosn);
        }
        JSONArray result = new JSONArray(list);
        if (esQuery.getCamelCase().booleanValue()) {
            result = CamelCaseUtil.listToCamelCase((JSONArray)result);
        }
        if (esQuery.getSelectOne().booleanValue()) {
            if (result.size() > 0) {
                return result.getJSONObject(0);
            }
            return new JSONObject();
        }
        return result;
    }

    private JSONObject getTotalCount(SearchResponse searchResponse, ProcessContent content, ESQuery esQuery) {
        if (!esQuery.getSelectTotalCount().booleanValue() || esQuery.getPageNum() == null) {
            return null;
        }
        JSONObject totalCountJson = new JSONObject();
        String totalCountReturnKey = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
        totalCountReturnKey = StringUtil.isBlank((String)totalCountReturnKey) ? "totalCount" : totalCountReturnKey;
        String totalPageReturnKey = this.variableUtil.calVarInConf(content, "totalPageReturnKey");
        totalPageReturnKey = StringUtil.isBlank((String)totalPageReturnKey) ? "totalPage" : totalPageReturnKey;
        long totalCount = searchResponse.getHits().getTotalHits().value;
        totalCountJson.put(totalCountReturnKey, (Object)totalCount);
        Integer pageSize = esQuery.getPageSize();
        Long totalPage = totalCount / (long)esQuery.getPageSize().intValue();
        if (totalPage * (long)pageSize.intValue() < totalCount) {
            Long l = totalPage;
            Long l2 = totalPage = Long.valueOf(totalPage + 1L);
        }
        totalCountJson.put(totalPageReturnKey, (Object)totalPage);
        return totalCountJson;
    }

    public String getName() {
        return "elasticsearchQuery";
    }
}

