/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.other;

import com.manatee.common.exception.BizException;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.ArithmeticCaptchaComponent;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetCaptchaFun
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(GetCaptchaFun.class);

    public Integer getMinParamSize() {
        return 0;
    }

    public Integer getMaxParamSize() {
        return 2;
    }

    public String getName() {
        return "getCaptcha";
    }

    public Object doFunction(FunctionContent content) throws BizException {
        this.checkParamSize(content);
        this.checkParamExist(content);
        List parameters = content.getParameters();
        if (parameters == null || parameters.size() <= 0) {
            return null;
        }
        Object type = parameters.get(0);
        if (type == null) {
            type = "arithmetic";
        }
        String typeStr = type.toString();
        Integer arithmeticLen = 2;
        if (parameters.size() > 1) {
            arithmeticLen = parameters.get(1);
        }
        Object captcha = null;
        switch (typeStr) {
            case "png": {
                captcha = new SpecCaptcha(130, 48);
                break;
            }
            case "gif": {
                captcha = new GifCaptcha(130, 48);
                break;
            }
            case "cn": {
                captcha = new ChineseCaptcha(130, 48, 5, new Font("\u6977\u4f53", 0, 28));
                break;
            }
            case "cngif": {
                captcha = new ChineseGifCaptcha(130, 48, 5, new Font("\u6977\u4f53", 0, 28));
                break;
            }
            case "arithmetic": {
                ArithmeticCaptchaComponent arithmeticCaptcha = new ArithmeticCaptchaComponent(130, 48);
                arithmeticCaptcha.setLen(Integer.parseInt(((Object)arithmeticLen).toString()));
                arithmeticCaptcha.getArithmeticString();
                arithmeticCaptcha.text();
                captcha = arithmeticCaptcha;
                break;
            }
            default: {
                new SpecCaptcha(130, 48);
            }
        }
        String uuid = UUID.randomUUID().toString();
        log.info("uuid:{},\u9a8c\u8bc1\u7801:{}", (Object)uuid, (Object)captcha.text());
        captcha.setCharType(1);
        String captchaBase64 = captcha.toBase64();
        HashMap<String, String> captchaMap = new HashMap<String, String>(2);
        captchaMap.put("captchaBase64", captchaBase64);
        captchaMap.put("uuid", uuid);
        captchaMap.put("captcha", captcha.text());
        return captchaMap;
    }
}

