/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.collection;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ListMapToMapFun
extends AbstractFunction {
    private String name = "listMapToMap";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        if (parameters.size() == 2) {
            List mapList = (List)parameters.get(0);
            String key = (String)parameters.get(1);
            LinkedHashMap result = new LinkedHashMap();
            for (Map m : mapList) {
                if (m.get(key) == null || m == null) continue;
                result.put(m.get(key), m);
            }
            return result;
        }
        List mapList = (List)parameters.get(0);
        String key = (String)parameters.get(1);
        String value = (String)parameters.get(2);
        LinkedHashMap result = new LinkedHashMap();
        for (Map m : mapList) {
            if (m.get(key) == null || m.get(value) == null) continue;
            result.put(m.get(key), m.get(value));
        }
        return result;
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 3;
    }
}

