/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.file.base.FtpUtilsFactory;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.process.store.handle.ManateeFileHandle;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.ProcessFileInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FtpUploadProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(FtpUploadProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private FtpUtilsFactory ftpUtilsFactory;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private ManateeFileHandle manateeFileHandle;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"remotePath"});
        String remotePath = this.variableUtil.calVarInConf(content, "remotePath");
        String fileSource = content.getStepConf().getString("fileSource");
        Boolean needDel = content.getStepConf().getBoolean("needDel");
        Boolean needMakeDirectory = content.getStepConf().getBoolean("needMakeDirectory");
        Boolean autoCover = content.getStepConf().getBoolean("autoCover");
        ArrayList fileInfos = new ArrayList();
        this.manateeFileHandle.getContentFiles(content, fileSource, needDel, autoCover, fileInfos);
        FTPClient ftpClient = this.ftpUtilsFactory.connectServer(content);
        ArrayList<String> path = new ArrayList<String>(fileInfos.size());
        try {
            ftpClient.changeWorkingDirectory(remotePath);
            ftpClient.setBufferSize(1024);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            if (needMakeDirectory != null && needMakeDirectory.booleanValue()) {
                ftpClient.makeDirectory(remotePath);
            }
            for (ProcessFileInfo fileItem : fileInfos) {
                InputStream inputStream = fileItem.getInputStream();
                try {
                    String remote = remotePath + "/" + fileItem.getFileName();
                    ftpClient.storeFile(remote, inputStream);
                    path.add(remotePath + "/" + fileItem.getFileName());
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    File file = fileItem.getFile();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileItem.getNeedDel() == null || !fileItem.getNeedDel().booleanValue() || file == null || !file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
        finally {
            FtpUtilsFactory.disconnect(ftpClient);
        }
        this.outputUtil.handleAndPutData(content, path);
    }

    public String getName() {
        return "ftpUpload";
    }
}

