/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.process.util;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.exp.domain.SyntaxContent;
import com.manatee.process.util.ManateeConditionUtil;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class ExpressionUtil {
    public static Map<String, String> symbolMap = new ConcurrentHashMap<String, String>();

    public static boolean isContainsFun(String a) {
        return a.contains(ManateeConditionUtil.ALLATORIxDEMO(")")) || a.contains(SyntaxContent.ALLATORIxDEMO("-"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValid(String a) {
        try {
            int n;
            Stack<String> stack = new Stack<String>();
            int n2 = n = 0;
            while (n2 < a.length()) {
                String string = a.charAt(n) + "";
                if (a.charAt(n) == '(') {
                    stack.push(string);
                } else if (a.charAt(n) == ')' && (String)stack.pop() == null) {
                    return false;
                }
                n2 = ++n;
            }
            return stack.size() == 0;
        }
        catch (EmptyStackException emptyStackException) {
            return false;
        }
    }

    public static void main(String[] a) {
        System.out.println(ManateeConditionUtil.ALLATORIxDEMO("\u000bn\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"G\"m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!n\u000bn!m!m!m!m\"n!n!m!n!m!m\"n!n\"n!n\"n!n\"m!n\"n!m!m!m!m\"G\"m!m!m!m\"m\"m\"m!m\"m!m\"m\"m!n!m\"m\"m\"m\"m!n!m!m!m!m!n\u000bn!m!m!m!n\"n!n!m!n!m!n\"n!m\"m!n!n!n\"m!m\"m!m!m!m!m\"G\"m!m!m!m\"m\"m\"n\"m\"n\"m\"m\"m!n!m\"n\"m\"m\"m\"n\"m!m!m!m!n\u000bn!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m\"G\"mN/g8r.`9h\"omc4!\fm!`9n?hmN/g8r.`9n?!;6c6mE\bL\u0002!n\u000bn!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m\"G\"m!m!m!m!m!mi9u=;b.:v:/,m!`9n?hcb\"lm!m!m!m!m!m!n\u000bn!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m!m\"G\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\"n\u000b"));
        ExpressionUtil.getConditionList(SyntaxContent.ALLATORIxDEMO("Um\\a\u000ehOwREB`\u000ehOwR-\u000f$Ow\u0006jIp\u0006jShJ$\u0000\"\u0006,BeReUkSvEa\u0006wReTpUSOpN$\u0004lRpV>\t+\u0004$Zx\u0006`GpGwIqTgC$UpGvRwqmRl\u0006&NpRtU>\t+\u0004-"));
    }

    public static String formatSymbolBack(String a) {
        Iterator<Map.Entry<String, String>> iterator;
        String string = a;
        Iterator<Map.Entry<String, String>> iterator2 = iterator = symbolMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator.next();
            String string2 = object.getValue();
            object = object.getKey();
            string = StringUtils.replace((String)string, (String)string2, (String)object);
            iterator2 = iterator;
        }
        return string;
    }

    private static /* synthetic */ String ALLATORIxDEMO(String a, int a2) {
        if (a2 < 1) {
            return null;
        }
        String string = a.substring(a2 - 1, a2);
        if (SyntaxContent.ALLATORIxDEMO("$").equals(string)) {
            return ExpressionUtil.ALLATORIxDEMO(a, a2 - 1);
        }
        return string;
    }

    public ExpressionUtil() {
        ExpressionUtil a;
    }

    static {
        symbolMap.put(ManateeConditionUtil.ALLATORIxDEMO(")"), SyntaxContent.ALLATORIxDEMO("'\u0005\\mL\u0005'"));
        symbolMap.put(ManateeConditionUtil.ALLATORIxDEMO("("), SyntaxContent.ALLATORIxDEMO("\u0005'\u007f\\mL\u0005'"));
        symbolMap.put(",", "##DH##");
        symbolMap.put("|", ManateeConditionUtil.ALLATORIxDEMO("\"nI\u0018Nn\""));
        symbolMap.put(SyntaxContent.ALLATORIxDEMO("\""), ManateeConditionUtil.ALLATORIxDEMO("\"nX\u0018On\""));
    }

    public static String specialSymbolHandle(String a) {
        String string = a;
        String[] stringArray = StringUtils.substringsBetween((String)string, (String)ManateeConditionUtil.ALLATORIxDEMO("#"), (String)SyntaxContent.ALLATORIxDEMO("&"));
        if (stringArray != null && stringArray.length > 0) {
            int n;
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String string2 = stringArray[n];
                String string3 = ExpressionUtil.specialSymbolReplace(string2);
                StringUtils.replace((String)a, (String)(ManateeConditionUtil.ALLATORIxDEMO("#") + string2 + SyntaxContent.ALLATORIxDEMO("&")), (String)new StringBuilder().insert(0, ManateeConditionUtil.ALLATORIxDEMO("#")).append(string3).append(SyntaxContent.ALLATORIxDEMO("&")).toString(), (int)1);
                n3 = ++n;
            }
        }
        return string;
    }

    public static String specialSymbolReplace(String a) {
        Iterator<Map.Entry<String, String>> iterator;
        String string = a;
        Iterator<Map.Entry<String, String>> iterator2 = iterator = symbolMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator.next();
            String string2 = object.getKey();
            object = object.getValue();
            string = StringUtils.replace((String)string, (String)string2, (String)object);
            iterator2 = iterator;
        }
        return string;
    }

    public static Map<Integer, Integer> getBracketsMapping(String a) {
        int n;
        Stack<Integer> stack = new Stack<Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = n = 0;
        while (n2 < a.length()) {
            if (a.charAt(n) == '(') {
                stack.add(n + 1);
                hashMap.put(n, null);
            } else if (a.charAt(n) == ')') {
                int n3 = (Integer)stack.pop();
                if (n3 > 0) {
                    hashMap.put(n3 - 1, n);
                } else if (n3 == 0) {
                    stack.add(0);
                }
            }
            n2 = ++n;
        }
        return hashMap;
    }

    public static List<String> getConditionList(String a) {
        String string = a;
        List<String> list = ExpressionUtil.getBracketsMapping(string).entrySet();
        HashSet<Map.Entry> hashSet = new HashSet<Map.Entry>();
        for (Map.Entry entry : list) {
            Integer n = (Integer)entry.getKey();
            Integer n2 = (Integer)entry.getValue();
            if (n == 0) {
                string = StrUtil.replace((CharSequence)string, (int)n, (int)(n + 1), (char)' ');
                string = StrUtil.replace((CharSequence)string, (int)n2, (int)(n2 + 1), (char)' ');
                hashSet.add(entry);
                continue;
            }
            if (n <= 0) continue;
            String string2 = ExpressionUtil.ALLATORIxDEMO(string, n);
            if (!SyntaxContent.ALLATORIxDEMO(",").equals(string2) && !ManateeConditionUtil.ALLATORIxDEMO("'").equals(string2) && !"|".equals(string2)) continue;
            string = StrUtil.replace((CharSequence)string, (int)n, (int)(n + 1), (char)' ');
            string = StrUtil.replace((CharSequence)string, (int)n2, (int)(n2 + 1), (char)' ');
            hashSet.add(entry);
        }
        string = string.trim();
        string = string.replaceAll(SyntaxContent.ALLATORIxDEMO("\u0000\""), ManateeConditionUtil.ALLATORIxDEMO("-a-"));
        string = string.replaceAll(SyntaxContent.ALLATORIxDEMO("\""), ManateeConditionUtil.ALLATORIxDEMO("-a-"));
        string = string.replaceAll(SyntaxContent.ALLATORIxDEMO("zxzx"), ManateeConditionUtil.ALLATORIxDEMO("-a-"));
        string = string.replaceAll("\\|", SyntaxContent.ALLATORIxDEMO("(\n("));
        list = Arrays.asList(StrUtil.split((CharSequence)string, (CharSequence)ManateeConditionUtil.ALLATORIxDEMO("-a-")));
        return list;
    }
}

