/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.domain.StrSplit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProcessCommonUtil {
    @Resource
    private VariableUtil variableUtil;

    public void setResult(ProcessContent content, JSONObject conf) {
        JSONObject response;
        if (conf == null || conf.size() == 0) {
            return;
        }
        JSONObject request = conf.getJSONObject("request");
        if (request != null) {
            String paramStr = this.variableUtil.calVar(content, request.toString());
            JSONObject paramJson = JSONObject.parseObject((String)paramStr);
            for (Map.Entry map : paramJson.entrySet()) {
                if (this.isParamFirst(conf) && content.getRequestSubValue((String)map.getKey()) != null) continue;
                content.putRequestSubValue((String)map.getKey(), map.getValue());
            }
        }
        if ((response = conf.getJSONObject("response")) != null) {
            String paramStr = this.variableUtil.calVar(content, response.toString());
            JSONObject paramJson = JSONObject.parseObject((String)paramStr);
            for (Map.Entry map : paramJson.entrySet()) {
                content.putResponseSubValue((String)map.getKey(), map.getValue());
            }
        }
    }

    private boolean isParamFirst(JSONObject conf) {
        Boolean paramFirst = conf.getBoolean("paramFirst");
        return Boolean.valueOf(true).equals(paramFirst);
    }

    public Object getValue(ProcessContent content, JSONObject conf, String key) {
        String valueFrom;
        if (conf == null) {
            conf = content.getStepConf();
        }
        if (key == null) {
            key = conf.getString("key");
        }
        if (StringUtil.isBlank((String)(valueFrom = conf.getString("valueFrom")))) {
            valueFrom = content.getStepConf().getString("valueFrom");
        }
        if (StringUtil.isBlank((String)valueFrom)) {
            return content.getValueFromRequestOrResponse(key);
        }
        if ("request".equals(valueFrom)) {
            return content.getRequestSubValue(key);
        }
        return content.getResponseSubValue(key);
    }

    public void putContent(ProcessContent content, JSONObject conf) {
        String key = conf.getString("key");
        Object value = this.getValue(content, conf);
        if (value == null) {
            return;
        }
        String type = conf.getString("type");
        if ("request".equals(type)) {
            Object oldValue = content.getRequest(key);
            if (this.needPut(oldValue, conf)) {
                content.putRequest(key, value);
            }
        } else {
            content.putResponseSubValue(key, value);
        }
    }

    public Object getValue(ProcessContent content, JSONObject conf) {
        Object value = conf.get((Object)"value");
        if (value != null && value instanceof String) {
            value = this.variableUtil.calVar(content, (String)value);
            return value;
        }
        return value;
    }

    private boolean needPut(Object oldValue, JSONObject conf) {
        Object overwrite = conf.get((Object)"overwrite");
        if (overwrite != null) {
            return true;
        }
        return oldValue == null;
    }

    public static Object getSubValue(Map<String, Object> resultMap, String key) {
        ProcessContent content = new ProcessContent();
        return content.getSubValue(resultMap, key);
    }

    public static String getKey(JSONObject conf, String confKey, String defaultValue) {
        String key = conf.getString(confKey);
        if (StringUtil.isBlank((String)key)) {
            key = defaultValue;
        }
        return key;
    }

    public static List<Map<String, Object>> getBatchRequest(ProcessContent content, JSONObject conf) {
        String key = ProcessCommonUtil.getBatchKey(conf);
        List batchRequest = (List)content.getRequestSubValue(key);
        return batchRequest;
    }

    public static int getDB(JSONObject conf) {
        int db = 8;
        if (conf.containsKey((Object)"db")) {
            db = Integer.valueOf(conf.get((Object)"db").toString());
        }
        return db;
    }

    public static String getBatchKey(JSONObject conf) {
        String key = conf.getString("batchRequest");
        if (StringUtil.isBlank((String)key)) {
            key = "batchRequest";
        }
        return key;
    }

    public static Object getSubRequest(ProcessContent content) {
        JSONObject conf = content.getStepConf();
        String queryResultKey = "QUERY_RESULT";
        if (conf.containsKey((Object)"queryResultKey")) {
            queryResultKey = conf.getString("queryResultKey");
        }
        Object result = null;
        if (queryResultKey.contains(StrSplit.P)) {
            String[] queryResultKeys = queryResultKey.split(StrSplit.PA);
            Map paramResultPar = (Map)content.getRequest(queryResultKeys[0]);
            if (paramResultPar != null) {
                result = paramResultPar.get(queryResultKeys[1]);
            }
        } else {
            result = content.getRequest(queryResultKey);
        }
        return result;
    }

    public List<Map<String, Object>> addKeyFromRequest(ProcessContent content, List<Map<String, Object>> paramList, JSONObject conf) {
        if (!conf.containsKey((Object)"addKeyFromRequest")) {
            return paramList;
        }
        String addKeyFromRequestStr = conf.getString("addKeyFromRequest");
        String[] addKeys = addKeyFromRequestStr.split(StrSplit.D);
        for (Map<String, Object> param : paramList) {
            for (String addKey : addKeys) {
                if (param.containsKey(addKey = this.variableUtil.calVar(content, addKey))) continue;
                Object valueObj = content.getRequestSubValue(addKey);
                content.putSubVal(param, addKey, valueObj);
            }
        }
        return paramList;
    }

    public static void initRequest(ProcessContent content, JSONObject conf) {
        if (!conf.containsKey((Object)"holdVariable")) {
            return;
        }
        String holdVariable = conf.getString("holdVariable");
        if ("default".equals(holdVariable)) {
            holdVariable = "userId,lang";
        }
        HashMap<String, Object> hold = new HashMap<String, Object>();
        String[] holdVariables = holdVariable.split(",");
        for (int i = 0; i < holdVariables.length; ++i) {
            String key = holdVariables[i];
            Object obj = content.getRequest(key);
            hold.put(key, obj);
        }
        content.setRequest(new HashMap());
        content.setRequest(hold);
    }

    public static void initResponse(ProcessContent content, JSONObject conf) {
        if (!conf.containsKey((Object)"cleanResponse")) {
            return;
        }
        content.setResponse(new HashMap());
    }

    public static void putContentResult(ProcessContent content, JSONObject conf, Map re) {
        if (re == null || re.size() == 0) {
            return;
        }
        if (conf != null && conf.containsKey((Object)"resultKey")) {
            String resultKey = conf.getString("resultKey");
            content.putResponseSubValue(resultKey, (Object)re);
        } else {
            content.putRequest(re);
        }
    }

    public static void putRequest(ProcessContent content, JSONObject conf, Map re) {
        if (re == null || re.size() == 0) {
            return;
        }
        if (conf != null && conf.containsKey((Object)"resultKey")) {
            String resultKey = conf.getString("resultKey");
            content.putRequestSubValue(resultKey, (Object)re);
        } else {
            content.putRequest(re);
        }
    }

    public static void putValue(ProcessContent content, Object data) {
        if (data == null) {
            return;
        }
        JSONObject conf = content.getStepConf();
        String queryResultKey = "QUERY_RESULT";
        if (conf.containsKey((Object)"queryResultKey")) {
            queryResultKey = conf.getString("queryResultKey");
        }
        if (data instanceof Long || data instanceof Integer) {
            content.putRequest(queryResultKey, data);
            return;
        }
        JSONObject value = ProcessCommonUtil.formatJson(data);
        Boolean putRequest = conf.getBoolean("putRequest");
        if (putRequest != null && putRequest.booleanValue()) {
            content.putRequest(queryResultKey, (Object)value.getInnerMap());
        } else {
            content.putResponse(value.getInnerMap());
        }
    }

    public static JSONObject formatJson(Object value) {
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        JSONObject result = new JSONObject();
        if (value instanceof JSONArray) {
            result.put("batchResult", value);
            return result;
        }
        String data = (String)value;
        if (StringUtil.isArry((String)data)) {
            JSONArray array = JSONArray.parseArray((String)data);
            result.put("batchResult", (Object)array);
        } else {
            result = JSONObject.parseObject((String)data, (Feature[])new Feature[]{Feature.OrderedField});
        }
        return result;
    }
}

