/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.sms.manager;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsRequest;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliyunSmsManager {
    @Value(value="${sms.aliyun.accessKeyId:}")
    public String accessKeyId;
    @Value(value="${sms.aliyun.secretAccessKey:}")
    public String secretAccessKey;

    public JSONObject sendSms(String phoneNumbers, String signName, String templateCode, String templateParam) throws BizException {
        try {
            Client client = this.getSmsClient();
            SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(phoneNumbers).setSignName(signName).setTemplateCode(templateCode).setTemplateParam(templateParam);
            SendSmsResponse sendSmsResponse = client.sendSms(sendSmsRequest);
            JSONObject result = new JSONObject();
            result.put("statusCode", (Object)sendSmsResponse.getStatusCode());
            result.put("body", (Object)sendSmsResponse.getBody());
            return result;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
    }

    public JSONObject querySendDetails(String phoneNumber, String bizId, String sendDate, Long pageSize, Long currentPage) throws BizException {
        try {
            Client client = this.getSmsClient();
            QuerySendDetailsRequest querySendDetailsRequest = new QuerySendDetailsRequest().setPhoneNumber(phoneNumber).setSendDate(sendDate).setPageSize(pageSize).setCurrentPage(currentPage);
            if (StringUtils.isNotBlank((CharSequence)bizId)) {
                querySendDetailsRequest.setBizId(bizId);
            }
            QuerySendDetailsResponse querySendDetailsResponse = client.querySendDetails(querySendDetailsRequest);
            JSONObject result = new JSONObject();
            result.put("statusCode", (Object)querySendDetailsResponse.getStatusCode());
            result.put("body", (Object)querySendDetailsResponse.getBody());
            return result;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
    }

    private Client getSmsClient() throws Exception {
        Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.secretAccessKey);
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new Client(config);
    }
}

