/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.constant.DatabaseProductNameEnum;
import com.manatee.lowcodedb.manager.DBAopManager;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbSqlAopBo;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.handler.ManateeListHandler;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ManateeSqlProcessV2
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(ManateeSqlProcessV2.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private DBAopManager dbAopManager;
    @Resource
    private ManateeDataSource manateeDataSource;
    private final String SELECT = "select";
    private final String NOT_SELECT = "not_select";
    private final String STORED_PROCEDURE = "stored_procedure";

    public void process(ProcessContent content) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        Connection conn = null;
        try {
            conn = this.manateeDataSource.getConnection(db);
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            String code = DatabaseProductNameEnum.getCodeByName(databaseProductName);
            if (StringUtils.isNotEmpty((CharSequence)code)) {
                this.defaultDatabaseProductName = code;
            }
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setDatabaseSql(content);
        this.processConfUtil.checkConf(content, new String[]{"sql"});
        String originalSql = content.getStepConf().getString("sql");
        String sqlType = content.getStepConf().getString("sqlType");
        DbSqlAopBo dbSqlAopBo = new DbSqlAopBo();
        dbSqlAopBo.setSqlType(sqlType);
        dbSqlAopBo.setSql(originalSql);
        this.dbAopManager.sqlBeforeFun(content, dbSqlAopBo);
        String executeSql = this.dBManager.sqlV2(content);
        ThreadLocalConnection.INSTANCE.setProcessContent(content);
        try {
            DbClient dbClient = DbClient.use(db);
            this.executeSql(content, dbClient, executeSql);
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
    }

    public String getName() {
        return "manateeSqlProcess_v2";
    }

    private void setDatabaseSql(ProcessContent content) throws BizException {
        JSONArray sqlArray = content.getStepConf().getJSONArray("originalSqlArray");
        if (sqlArray == null || sqlArray.size() <= 0) {
            sqlArray = content.getStepConf().getJSONArray("sql");
            content.getStepConf().put("originalSqlArray", (Object)sqlArray);
        }
        String sql = null;
        HashMap<String, Integer> isRepeat = new HashMap<String, Integer>();
        for (int i = 0; i < sqlArray.size(); ++i) {
            String dbType = sqlArray.getJSONObject(i).get((Object)"dbType").toString();
            if (this.defaultDatabaseProductName.equals(dbType)) {
                sql = sqlArray.getJSONObject(i).getString("sql");
            }
            if (isRepeat.containsKey(dbType)) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "\u5b58\u5728\u91cd\u590d\u7c7b\u578bSQL\uff0c\u8bf7\u68c0\u67e5\u5220\u9664\u540e\u91cd\u8bd5");
            }
            isRepeat.put(dbType, 1);
        }
        if (sql == null && sqlArray != null && sqlArray.size() > 0) {
            sql = sqlArray.getJSONObject(0).getString("sql");
        }
        if (sql != null) {
            sql = sql.trim();
            content.getStepConf().put("sql", (Object)sql);
            return;
        }
        throw new BizException(ResultCode.PARAM_IS_ERROR, "\u8bf7\u586b\u5199\u5bf9\u5e94\u6570\u636e\u5e93SQL\u8bed\u53e5");
    }

    private void executeSql(ProcessContent content, DbClient dbClient, String executeSql) throws BizException {
        String sqlType = content.getStepConf().getString("sqlType");
        if (StringUtils.isNotBlank((CharSequence)sqlType)) {
            if ("select".equalsIgnoreCase(sqlType)) {
                this.executeQueryAndOutput(content, dbClient, executeSql);
            } else if ("not_select".equalsIgnoreCase(sqlType)) {
                this.executeUpdateAndOutput(content, dbClient, executeSql);
            } else if ("stored_procedure".equalsIgnoreCase(sqlType)) {
                this.executeCallAndOutput(content, dbClient, executeSql);
            } else {
                throw new BizException(ResultCode.CONF_ERROR);
            }
        }
    }

    private void executeQueryAndOutput(ProcessContent content, DbClient dbClient, String executeSql) throws BizException {
        String pageNumStr = this.variableUtil.calVarInConf(content, "pageNum");
        String pageSizeStr = this.variableUtil.calVarInConf(content, "pageSize");
        Object pageNumObj = content.getValue(pageNumStr);
        Object pageSizeObj = content.getValue(pageSizeStr);
        Boolean camelCaseData = content.getStepConf().getBoolean("camelCase");
        String upperOrLowerCaseData = content.getStepConf().getString("upperOrLowerCase");
        SqlBuilder pageSql = SqlBuilder.of(executeSql);
        if (pageNumObj != null && pageSizeObj != null) {
            pageSql = dbClient.pageSql(pageSql, Integer.parseInt(pageNumObj.toString()) - 1, Integer.parseInt(pageSizeObj.toString()), camelCaseData, upperOrLowerCaseData);
        }
        Boolean selectOneData = content.getStepConf().getBoolean("selectOne");
        JSON data = this.executeSelectSql(content, dbClient, pageSql.build(), camelCaseData, upperOrLowerCaseData, selectOneData);
        DbSqlAopBo dbSqlAopBo = new DbSqlAopBo();
        dbSqlAopBo.setSqlType("select");
        dbSqlAopBo.setResultData(data);
        this.dbAopManager.sqlAfterFun(content, dbSqlAopBo);
        Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
        if (returnDataShow != null && Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
            this.outputUtil.setDefaultReturnKey(content, "outputData");
        }
        String syntaxType = content.getStepConf().getString("syntaxTypeDataProcess");
        this.outputUtil.handleAndPutDataV2(content, (Object)data, syntaxType);
        JSONObject totalCountJson = this.querySqlTotalCount(content, dbClient, executeSql, pageNumObj, pageSizeObj, camelCaseData, upperOrLowerCaseData);
        if (totalCountJson != null) {
            this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
        }
    }

    public JSON executeSelectSql(ProcessContent content, DbClient dbClient, String executeSql, Boolean camelCaseData, String upperOrLowerCaseData, Boolean selectOneData) throws BizException {
        List<DbEntity> list;
        try {
            ArrayList paramsList = (ArrayList)content.getStepConf().get((Object)"manateeSqlProcessParamValues");
            if (paramsList == null) {
                paramsList = new ArrayList();
            }
            list = dbClient.query(executeSql, new ManateeListHandler(false, camelCaseData, upperOrLowerCaseData), paramsList.toArray());
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String oracleNonQuery = "ORA-01002";
            String mysqlNonQuery1 = "Statement.executeQuery() cannot issue statements that do not produce result sets.";
            String mysqlNonQuery2 = "Can not issue data manipulation statements with executeQuery().";
            String pgsqlNonQuery = "\u67e5\u8be2\u6ca1\u6709\u4f20\u56de\u4efb\u4f55\u7ed3\u679c";
            String sqlServerNonQuery = "The executeQuery method must return a result set.";
            if (message.contains(oracleNonQuery) || message.contains(mysqlNonQuery1) || message.contains(mysqlNonQuery2) || message.contains(pgsqlNonQuery) || message.contains(sqlServerNonQuery)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u975e\u67e5\u8be2\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u67e5\u8be2\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        if (selectOneData != null && selectOneData.booleanValue()) {
            JSONObject jsonObject = list != null && list.size() > 0 ? new JSONObject((Map)((Object)list.get(0))) : null;
            return jsonObject;
        }
        JSONArray dataArray = new JSONArray();
        if (list != null && list.size() > 0) {
            dataArray.addAll(list);
        }
        return dataArray;
    }

    public JSONObject querySqlTotalCount(ProcessContent content, DbClient dbClient, String executeSql, Object pageNumObj, Object pageSizeObj, Boolean camelCaseData, String upperOrLowerCaseData) throws BizException {
        Integer integer;
        Boolean selectTotalCountData = content.getStepConf().getBoolean("selectTotalCount");
        if (selectTotalCountData == null || !selectTotalCountData.booleanValue() || pageNumObj == null || pageSizeObj == null) {
            return null;
        }
        JSONObject totalCountJson = new JSONObject();
        String totalCountReturnKey = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
        totalCountReturnKey = StringUtil.isBlank((String)totalCountReturnKey) ? "totalCount" : totalCountReturnKey;
        String totalPageReturnKey = this.variableUtil.calVarInConf(content, "totalPageReturnKey");
        totalPageReturnKey = StringUtil.isBlank((String)totalPageReturnKey) ? "totalPage" : totalPageReturnKey;
        String countSql = dbClient.pageCountSql(executeSql);
        JSONObject countJson = (JSONObject)this.executeSelectSql(content, dbClient, countSql, camelCaseData, upperOrLowerCaseData, true);
        Integer n = countJson.getInteger("count(*)") == null ? (countJson.getInteger("count()") == null ? countJson.getInteger("COUNT(*)") : countJson.getInteger("count()")) : (integer = countJson.getInteger("count(*)"));
        if (countJson != null && integer != null) {
            Integer totalCount = integer;
            totalCountJson.put(totalCountReturnKey, (Object)totalCount);
            Integer pageSize = Integer.parseInt(pageSizeObj.toString());
            if (pageSize != null && pageSize > 0) {
                Integer totalPage = totalCount / pageSize;
                if (totalPage * pageSize < totalCount) {
                    Integer n2 = totalPage;
                    Integer n3 = totalPage = Integer.valueOf(totalPage + 1);
                }
                totalCountJson.put(totalPageReturnKey, (Object)totalPage);
            }
        }
        return totalCountJson;
    }

    private void executeUpdateAndOutput(ProcessContent content, DbClient dbClient, String executeSql) throws BizException {
        int count = this.executeNotSelectSql(content, dbClient, executeSql);
        DbSqlAopBo dbSqlAopBo = new DbSqlAopBo();
        dbSqlAopBo.setSqlType("not_select");
        dbSqlAopBo.setResultData(count);
        this.dbAopManager.sqlAfterFun(content, dbSqlAopBo);
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)count);
    }

    public int executeNotSelectSql(ProcessContent content, DbClient dbClient, String executeSql) throws BizException {
        try {
            ArrayList paramsList = (ArrayList)content.getStepConf().get((Object)"manateeSqlProcessParamValues");
            if (paramsList == null) {
                paramsList = new ArrayList();
            }
            int count = dbClient.execute(executeSql, paramsList.toArray());
            return count;
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String mysqlNonUpdate1 = "Can not issue executeUpdate() or executeLargeUpdate() for SELECTs";
            String mysqlNonUpdate2 = "Can not issue executeUpdate() or executeLargeUpdate() with statements that produce result sets";
            String damengNonUpdate = "\u975e\u6cd5\u7684SQL\u8bed\u53e5\u7c7b\u578b";
            String pgsqlNonUpdate = "\u4f20\u56de\u9884\u671f\u4e4b\u5916\u7684\u7ed3\u679c";
            String sqlServerNonUpdate = "The executeUpdate method must not return a result set.";
            if (message.contains(mysqlNonUpdate1) || message.contains(mysqlNonUpdate2) || message.contains(damengNonUpdate) || message.contains(pgsqlNonUpdate) || message.contains(sqlServerNonUpdate)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u67e5\u8be2\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u975e\u67e5\u8be2\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
    }

    private void executeCallAndOutput(ProcessContent content, DbClient dbClient, String executeSql) throws BizException {
        Boolean camelCaseData = content.getStepConf().getBoolean("camelCase");
        String upperOrLowerCaseData = content.getStepConf().getString("upperOrLowerCase");
        JSON data = this.executeCallSql(content, dbClient, executeSql, camelCaseData, upperOrLowerCaseData);
        DbSqlAopBo dbSqlAopBo = new DbSqlAopBo();
        dbSqlAopBo.setSqlType("stored_procedure");
        dbSqlAopBo.setResultData(data);
        this.dbAopManager.sqlAfterFun(content, dbSqlAopBo);
        if (data != null) {
            Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
            if (returnDataShow != null && Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
                this.outputUtil.setDefaultReturnKey(content, "outputData");
            } else {
                this.outputUtil.setDefaultReturnKey(content, "outputUnfold");
            }
            this.outputUtil.handleAndPutData(content, (Object)data);
        }
    }

    public JSON executeCallSql(ProcessContent content, DbClient dbClient, String executeSql, Boolean camelCaseData, String upperOrLowerCaseData) throws BizException {
        JSONObject resultJson;
        try {
            ArrayList paramsList = (ArrayList)content.getStepConf().get((Object)"manateeSqlProcessParamValues");
            if (paramsList == null) {
                paramsList = new ArrayList();
            }
            Map outParams = (Map)content.getStepConf().get((Object)"manateeSqlProcessOutParams");
            resultJson = (JSONObject)dbClient.executeCall(executeSql, new ManateeListHandler(false, camelCaseData, upperOrLowerCaseData), outParams, paramsList.toArray());
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String oracleNonQuery = "ORA-01002";
            String mysqlNonQuery1 = "Statement.executeQuery() cannot issue statements that do not produce result sets.";
            String mysqlNonQuery2 = "Can not issue data manipulation statements with executeQuery().";
            String pgsqlNonQuery = "\u67e5\u8be2\u6ca1\u6709\u4f20\u56de\u4efb\u4f55\u7ed3\u679c";
            String sqlServerNonQuery = "The executeQuery method must return a result set.";
            if (message.contains(oracleNonQuery) || message.contains(mysqlNonQuery1) || message.contains(mysqlNonQuery2) || message.contains(pgsqlNonQuery) || message.contains(sqlServerNonQuery)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u5b58\u50a8\u8fc7\u7a0b\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u975e\u5b58\u50a8\u8fc7\u7a0b\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        return resultJson;
    }
}

