/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcodedb.newdb.DbDeleteAopBo;
import com.manatee.lowcodedb.newdb.DbQueryAopBo;
import com.manatee.lowcodedb.newdb.DbSqlAopBo;
import com.manatee.lowcodedb.newdb.DbUpdateAopBo;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ModuleBO;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DBAopManager {
    private static final Logger log = LoggerFactory.getLogger(DBAopManager.class);
    @Value(value="${manatee.db.aop.query.before:}")
    public String queryBefore;
    @Value(value="${manatee.db.aop.query.after:}")
    public String queryAfter;
    @Value(value="${manatee.db.aop.update.before:}")
    public String updateBefore;
    @Value(value="${manatee.db.aop.update.after:}")
    public String updateAfter;
    @Value(value="${manatee.db.aop.delete.before:}")
    public String deleteBefore;
    @Value(value="${manatee.db.aop.delete.after:}")
    public String deleteAfter;
    @Value(value="${manatee.db.aop.sql.before:}")
    public String sqlBefore;
    @Value(value="${manatee.db.aop.sql.after:}")
    public String sqlAfter;
    @Resource
    protected InputUtil inputUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    private ProcessChain processChain;

    public void queryBeforeFun(ProcessContent content, DbQueryAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.queryBefore)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.queryBefore, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbQueryAop", (Object)bo);
        log.debug("\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.queryBefore);
        this.executeModule(params, content, this.queryBefore);
        log.debug("\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.queryBefore);
    }

    public void queryAfterFun(ProcessContent content, DbQueryAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.queryAfter)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.queryAfter, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbQueryAop", (Object)bo);
        log.debug("\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.queryAfter);
        this.executeModule(params, content, this.queryAfter);
        log.debug("\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.queryAfter);
    }

    public void insertOrUpdateBeforeFun(ProcessContent content, DbUpdateAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.updateBefore)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.updateBefore, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbUpdateAop", (Object)bo);
        log.debug("\u65b0\u589e/\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.updateBefore);
        this.executeModule(params, content, this.updateBefore);
        log.debug("\u65b0\u589e/\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.updateBefore);
    }

    public void insertOrUpdateAfterFun(ProcessContent content, DbUpdateAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.updateAfter)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.updateAfter, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbUpdateAop", (Object)bo);
        log.debug("\u65b0\u589e/\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.updateAfter);
        this.executeModule(params, content, this.updateAfter);
        log.debug("\u65b0\u589e/\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.updateAfter);
    }

    public void deleteBeforeFun(ProcessContent content, DbDeleteAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.deleteBefore)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.deleteBefore, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbDeleteAop", (Object)bo);
        log.debug("\u5220\u9664\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.deleteBefore);
        this.executeModule(params, content, this.deleteBefore);
        log.debug("\u5220\u9664\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.deleteBefore);
    }

    public void deleteAfterFun(ProcessContent content, DbDeleteAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.deleteAfter)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.deleteAfter, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbDeleteAop", (Object)bo);
        log.debug("\u5220\u9664\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.deleteAfter);
        this.executeModule(params, content, this.deleteAfter);
        log.debug("\u5220\u9664\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.deleteAfter);
    }

    public void sqlBeforeFun(ProcessContent content, DbSqlAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.deleteBefore)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.deleteBefore, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbSqlAop", (Object)bo);
        log.debug("sql\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.deleteBefore);
        this.executeModule(params, content, this.deleteBefore);
        log.debug("sql\u8bed\u53e5\u6267\u884c\u524d\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.deleteBefore);
    }

    public void sqlAfterFun(ProcessContent content, DbSqlAopBo bo) throws BizException {
        if (StringUtils.isBlank((CharSequence)this.deleteAfter)) {
            return;
        }
        String moduleCode = content.getCode();
        if (StringUtils.equals((CharSequence)this.deleteAfter, (CharSequence)moduleCode)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("manateeDbSqlAop", (Object)bo);
        log.debug("sql\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u5f00\u59cb\uff1a{}", (Object)this.deleteAfter);
        this.executeModule(params, content, this.deleteAfter);
        log.debug("sql\u8bed\u53e5\u6267\u884c\u540e\uff0c\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)this.deleteAfter);
    }

    private void executeModule(JSONObject params, ProcessContent content, String moduleCode) throws BizException {
        Long projectId = content.getProjectId();
        if (projectId == 0L) {
            return;
        }
        ModuleBO moduleBO = this.processDataSource.getData(moduleCode, projectId);
        if (moduleBO == null) {
            return;
        }
        JSONObject tempModuleJson = new JSONObject();
        tempModuleJson.put("systemVersion", (Object)moduleBO.getSystemVersion());
        tempModuleJson.put("name", (Object)moduleBO.getName());
        tempModuleJson.put("url", (Object)moduleBO.getPath());
        tempModuleJson.put("lowcodeModule", (Object)moduleBO.getCode());
        ProcessContent moduleContent = new ProcessContent();
        moduleContent.setRequest((Map)params);
        moduleContent.setModule(tempModuleJson);
        moduleContent.setHeader(content.getHeader());
        moduleContent.putTempContent("lowcodeProjectId", (Object)projectId);
        moduleContent.putTempContent("lowcodeModule", (Object)moduleCode);
        List steps = moduleBO.getSteps();
        this.processChain.executeSteps(moduleContent, steps);
        Map moduleResponse = moduleContent.getResponse();
        this.outputUtil.handleAndPutData(content, (Object)moduleResponse);
        log.debug("\u6d41\u7a0bcode\uff1a{}\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)moduleCode, (Object)JSONObject.toJSONString((Object)moduleResponse));
    }
}

