/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.init;

import com.alibaba.fastjson.JSONArray;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.java.manager.JavaProcessManager;
import com.manatee.lowcode.manager.LowcodeCompilerManager;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class LocalProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(LocalProcessor.class);
    private static Logger LOGGER = LoggerFactory.getLogger(LocalProcessor.class);
    @Resource
    private JavaProcessManager javaProcessManager;
    @Resource
    private LowcodeCompilerManager lowcodeCompilerManager;
    private JSONArray compers;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        try {
            if (this.compers == null) {
                this.compers = this.lowcodeCompilerManager.findCompers(0L);
            }
            if (this.compers == null || this.compers.size() <= 0) {
                return bean;
            }
            for (Object comper : this.compers) {
                TreeMap lowcodeCompiler = (TreeMap)comper;
                String newBeanName = (String)lowcodeCompiler.get("bean_name");
                if (!beanName.equals(newBeanName)) continue;
                Object javaBean = this.javaProcessManager.getBean(beanName);
                if (javaBean != null) {
                    this.javaProcessManager.removeBean(beanName);
                }
                Object load = this.javaProcessManager.load(lowcodeCompiler);
                this.lowcodeCompilerManager.updateCompilerById((Long)lowcodeCompiler.get("id"), (String)lowcodeCompiler.get("compiler_code"), (byte[])lowcodeCompiler.get("compiler_data"), 0);
                bean = null;
                return load;
            }
        }
        catch (BizException e) {
            LOGGER.debug("manatee load error", (Throwable)e);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

