/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.web.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultTrace;
import com.manatee.lowcode.domain.ModularityRequest;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.iutil.IModularityManager;
import com.manatee.lowcode.util.ProcessParamUtil;
import com.manatee.lowcode.util.WebUtil;
import com.manatee.lowcode.web.base.CustomizeModuleManagerBase;
import com.manatee.process.ProcessChain;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;

@Service
public class ModularityManager
extends CustomizeModuleManagerBase
implements IModularityManager {
    @Resource
    private ProcessChain processChain;
    @Resource
    private WebUtil webUtil;
    @Resource
    private ApplicationContext applicationContext;

    public ModularityResult executionModule(Long projectId, String code, Map<String, Object> params) {
        ProcessContent content = new ProcessContent();
        content.setCode(code);
        content.setProjectId(projectId);
        if (params != null) {
            content.getRequest().putAll(params);
        }
        return this.execution(content);
    }

    private ModularityResult executionModule(Long projectId, String code, Map<String, Object> params, String traceId) {
        ProcessContent content = new ProcessContent();
        content.setCode(code);
        content.setProjectId(projectId);
        content.setTraceId(traceId);
        if (params != null) {
            content.getRequest().putAll(params);
        }
        return this.execution(content);
    }

    public ModularityResult executionModuleMap(Long projectId, String code, Map<String, Object> params) {
        return this.executionModule(projectId, code, params);
    }

    public ModularityResult executionModule(Long projectId, String code, Object param) {
        ModularityRequest request = new ModularityRequest();
        request.setCode(code);
        request.setProjectId(Long.valueOf(projectId + ""));
        if (param instanceof JSONObject) {
            request.setParams((Map)((JSONObject)param));
        } else if (param instanceof String) {
            JSONObject paramjson = JSONObject.parseObject((String)((String)param));
            request.setParams((Map)paramjson);
        } else if (param instanceof Map) {
            return this.executionModule(projectId, code, (Map)param);
        }
        return this.executionModule(request);
    }

    public ModularityResult executionModule(Long projectId, String code, Object param, String traceId) {
        ModularityRequest request = new ModularityRequest();
        request.setCode(code);
        request.setProjectId(Long.valueOf(projectId + ""));
        request.setTraceId(traceId);
        if (param instanceof JSONObject) {
            request.setParams((Map)((JSONObject)param));
        } else if (param instanceof String) {
            JSONObject paramjson = JSONObject.parseObject((String)((String)param));
            request.setParams((Map)paramjson);
        } else if (param instanceof Map) {
            return this.executionModule(projectId, code, (Map<String, Object>)((Map)param), traceId);
        }
        return this.executionModule(request);
    }

    public ModularityResult executionModule(Long projectId, String code, Map<String, Object> params, Map<String, Object> header) {
        ProcessContent content = new ProcessContent();
        content.setCode(code);
        content.setProjectId(projectId);
        if (params != null) {
            content.getRequest().putAll(params);
        }
        if (header != null) {
            content.setHeader(header);
        }
        return this.execution(content);
    }

    public ModularityResult executionModule(ModularityRequest request) {
        Map params;
        ProcessContent content = new ProcessContent();
        content.setCode(request.getCode());
        content.setProjectId(request.getProjectId());
        content.setTraceId(request.getTraceId());
        content.setHeader(request.getHeaders());
        if (request.getUserId() != null) {
            content.putTempContent("userId", (Object)request.getUserId());
        }
        if ((params = request.getParams()) != null) {
            content.getRequest().putAll(params);
        }
        return this.execution(content);
    }

    public JSONObject executionModuleResultJson(Long projectId, String code, Map<String, Object> params) {
        ProcessContent content = new ProcessContent();
        content.setCode(code);
        content.setProjectId(projectId);
        if (params != null) {
            content.getRequest().putAll(params);
        }
        return this.executionJson(content);
    }

    public JSONObject executionModuleResultJson(ModularityRequest request) {
        Map params;
        ProcessContent content = new ProcessContent();
        content.setCode(request.getCode());
        content.setProjectId(request.getProjectId());
        content.setTraceId(request.getTraceId());
        content.setHeader(request.getHeaders());
        if (request.getUserId() != null) {
            content.putTempContent("userId", (Object)request.getUserId());
        }
        if ((params = request.getParams()) != null) {
            content.getRequest().putAll(params);
        }
        return this.executionJson(content);
    }

    public JSONObject executionModuleResultJson(Long projectId, String code, Object param) {
        ModularityRequest request = new ModularityRequest();
        request.setCode(code);
        request.setProjectId(Long.valueOf(projectId + ""));
        if (param instanceof JSONObject) {
            request.setParams((Map)((JSONObject)param));
        } else if (param instanceof String) {
            JSONObject paramjson = JSONObject.parseObject((String)((String)param));
            request.setParams((Map)paramjson);
        } else if (param instanceof Map) {
            return this.executionModuleResultJson(projectId, code, (Map)param);
        }
        return this.executionModuleResultJson(request);
    }

    public JSONObject executionModuleResultJsonByTransactionCon(Long projectId, String code, Map<String, Object> params) {
        ProcessContent content = new ProcessContent();
        content.setCode(code);
        content.setProjectId(projectId);
        DataSource dataSource = (DataSource)this.applicationContext.getBean(DataSource.class);
        Connection transactionCon = DataSourceUtils.getConnection((DataSource)dataSource);
        content.setTransactionCon(transactionCon);
        if (params != null) {
            content.getRequest().putAll(params);
        }
        return this.executionJson(content);
    }

    private ModularityResult execution(ProcessContent content) {
        ProcessParamUtil.initTraceId((ProcessContent)content);
        String code = content.getCode();
        HashMap map = new HashMap(content.getRequest());
        map.remove("tempContext");
        map.remove("cells");
        String params = JSONObject.toJSONString(map);
        log.info("[ModularityManager.executionModule]_moduleInfo,projectId: {}, moduleCode: {}, params: {}", new Object[]{content.getProjectId(), code, params});
        try {
            this.processChain.execute(content);
        }
        catch (Throwable e) {
            this.log(content, e);
        }
        ModularityResult result = this.webUtil.wirteLowcodeResult(content);
        if (result.isSuccess()) {
            log.warn("[ModularityManager.executionModule]_success,code:{},projectId:{},traceId:{}", new Object[]{code, content.getProjectId(), content.getTraceId()});
        } else {
            log.error("[ModularityManager.executionModule]_biz_error,code:{},projectId:{},code:{},subCode:{},traceId:{}", new Object[]{code, content.getProjectId(), result.getCode(), result.getSubCode(), content.getTraceId()});
        }
        return result;
    }

    private JSONObject executionJson(ProcessContent content) {
        ProcessParamUtil.initTraceId((ProcessContent)content);
        String code = content.getCode();
        HashMap map = new HashMap(content.getRequest());
        map.remove("tempContext");
        map.remove("cells");
        String params = JSONObject.toJSONString(map);
        log.info("[ModularityManager.executionModule]_moduleInfo,projectId: {}, moduleCode: {}, params: {}", new Object[]{content.getProjectId(), code, params});
        try {
            this.processChain.execute(content);
        }
        catch (Throwable e) {
            this.log(content, e);
        }
        JSONObject result = this.webUtil.wirteLowcodeResultJson(content);
        ResultTrace resultTrace = content.getErrorTrace().getResultTrace();
        if (resultTrace.getId() >= 0) {
            log.warn("[ModularityManager.executionModule]_success,code:{},projectId:{},traceId:{}", new Object[]{code, content.getProjectId(), content.getTraceId()});
        } else {
            log.error("[ModularityManager.executionModule]_biz_error,code:{},projectId:{},code:{},subCode:{},traceId:{}", new Object[]{code, content.getProjectId(), resultTrace.getCode(), resultTrace.getSubCode(), content.getTraceId()});
        }
        return result;
    }
}

