/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.store.filedownload;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class FileDownloadProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        String fileUri = this.variableUtil.calVarInConf(content, "fileUri");
        String classpath = this.variableUtil.calVarInConf(content, "classpath");
        Boolean needDel = content.getStepConf().getBoolean("needDel");
        String returnKey = null;
        returnKey = needDel != null && needDel != false ? "lowcodeTempFileUrl" : "lowcodeFileUrl";
        if (fileUri != null && !fileUri.isEmpty()) {
            File file = new File(fileUri);
            if (!file.exists()) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            content.getStepConf().put("returnKey", (Object)returnKey);
            this.outputUtil.putData(content, (Object)fileUri);
        } else if (classpath != null && !classpath.isEmpty()) {
            ClassPathResource resource = new ClassPathResource(classpath);
            if (!resource.exists()) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            File tempDir = new File(GlobalConf.TEMP_DIRECTORY);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File file = new File(tempDir + "/" + classpath);
            try {
                FileUtils.copyToFile((InputStream)resource.getInputStream(), (File)file);
            }
            catch (Exception e) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String url = file.getPath();
            if (!file.exists()) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            content.getStepConf().put("returnKey", (Object)returnKey);
            this.outputUtil.putData(content, (Object)url);
        } else {
            String fileType = this.variableUtil.calVarInConf(content, "fileType");
            String fileName = this.variableUtil.calVarInConf(content, "fileName");
            String paramsKey = this.variableUtil.calVarInConf(content, "paramsKey");
            File tempDir = new File(GlobalConf.TEMP_DIRECTORY);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File file = new File(tempDir + "/" + fileName + "." + fileType);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String fileContent = "";
            Object obj = content.getRequest(paramsKey);
            if (obj instanceof byte[]) {
                this.writeToFile((byte[])obj, file);
            } else {
                fileContent = obj.toString();
                this.writeToFile(fileContent, file);
            }
            String url = GlobalConf.TEMP_DIRECTORY + fileName + "." + fileType;
            content.getStepConf().put("returnKey", (Object)returnKey);
            this.outputUtil.putData(content, (Object)url);
        }
    }

    public void writeToFile(String text, File file) {
        try {
            int len;
            BufferedReader br = new BufferedReader(new StringReader(text));
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            char[] buf = new char[65536];
            while ((len = br.read(buf)) != -1) {
                bw.write(buf, 0, len);
            }
            bw.flush();
            br.close();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(byte[] bytes, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getName() {
        return "fileDownload";
    }
}

