/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.js;

import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ManateeClassScanner {
    private static List<String> result;

    public static List<String> scan() throws URISyntaxException, IOException {
        JSONObject jsonObject = new JSONObject(4);
        if (result != null) {
            return result;
        }
        HashSet<String> classes = new HashSet<String>();
        if (Double.parseDouble(System.getProperty("java.specification.version")) >= 11.0) {
            classes.addAll(ManateeClassScanner.latestJdkScan());
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        do {
            if (!(loader instanceof URLClassLoader)) continue;
            classes.addAll(ManateeClassScanner.scan(((URLClassLoader)loader).getURLs()));
        } while ((loader = loader.getParent()) != null);
        classes.addAll(ManateeClassScanner.addJavaLibrary());
        return new ArrayList<String>(classes);
    }

    public static List<String> latestJdkScan() throws IOException {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resourcePatternResolver.getResources("classpath*:**/**.class");
        return Arrays.asList(resources).parallelStream().map(it -> {
            try {
                if (ManateeClassScanner.isClass(it.getURL().getPath())) {
                    if ("\"classes\"".contains(it.getURL().getPath())) {
                        return it.getURL().getPath().split("classes")[1].substring(1).replace(".class", "").replaceAll("\\/", ".");
                    }
                    if (it.getURL().getPath().split("!").length > 1) {
                        return it.getURL().getPath().split("!")[1].substring(1).replace(".class", "").replaceAll("\\/", ".");
                    }
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Objects::toString)).collect(Collectors.toList());
    }

    public static String compress(List<String> classes) {
        Collections.sort(classes);
        String currentPackage = "";
        StringBuffer buf = new StringBuffer();
        int classCount = 0;
        for (String fullName : classes) {
            String packageName = "";
            String className = fullName;
            if (fullName.contains(".")) {
                int index = fullName.lastIndexOf(".");
                className = fullName.substring(index + 1);
                packageName = fullName.substring(0, index);
            }
            if (className.equals("package-info")) continue;
            if (currentPackage.equals(packageName)) {
                if (classCount > 0) {
                    buf.append(",");
                }
                buf.append(className);
                ++classCount;
                continue;
            }
            currentPackage = packageName;
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(packageName);
            buf.append(":");
            buf.append(className);
            classCount = 1;
        }
        return buf.toString();
    }

    private static Set<String> scan(URL[] urls) throws URISyntaxException {
        HashSet<String> classes = new HashSet<String>();
        if (urls != null) {
            for (URL url : urls) {
                String protocol = url.getProtocol();
                if ("file".equalsIgnoreCase(protocol)) {
                    String path = url.getPath();
                    if (path.toLowerCase().endsWith(".jar")) {
                        classes.addAll(ManateeClassScanner.scanJarFile(url));
                        continue;
                    }
                    classes.addAll(ManateeClassScanner.scanDirectory(new File(url.toURI()), null));
                    continue;
                }
                if (!"jar".equalsIgnoreCase(protocol)) continue;
                classes.addAll(ManateeClassScanner.scanJarFile(url));
            }
        }
        return classes;
    }

    private static Set<String> addJavaLibrary() {
        int version = ManateeClassScanner.checkJavaVersion();
        if (version >= 9) {
            return ManateeClassScanner.addJava9PlusLibrary();
        }
        return ManateeClassScanner.addJava8Library();
    }

    private static int checkJavaVersion() {
        String version = System.getProperty("java.version");
        int index = version.indexOf(".");
        if (index > -1) {
            String first = version.substring(0, index);
            if (!"1".equals(first)) {
                return ManateeClassScanner.asInt(first, -1);
            }
            int endIndex = version.indexOf(".", index + 1);
            return ManateeClassScanner.asInt(version.substring(index + 1, endIndex), -1);
        }
        return -1;
    }

    private static Set<String> addJava8Library() {
        try {
            Object classpath = Class.forName("sun.misc.Launcher").getMethod("getBootstrapClassPath", new Class[0]).invoke(null, new Object[0]);
            return ManateeClassScanner.scan((URL[])classpath.getClass().getMethod("getURLs", new Class[0]).invoke(classpath, new Object[0]));
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    private static Set<String> addJava9PlusLibrary() {
        HashSet<String> classes = new HashSet<String>();
        try {
            Class<?> moduleLayer = Class.forName("java.lang.ModuleLayer");
            Object boot = moduleLayer.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            Object configuration = moduleLayer.getMethod("configuration", new Class[0]).invoke(boot, new Object[0]);
            Set modules = (Set)Class.forName("java.lang.module.Configuration").getMethod("modules", new Class[0]).invoke(configuration, new Object[0]);
            Method reference = Class.forName("java.lang.module.ResolvedModule").getMethod("reference", new Class[0]);
            Method open = Class.forName("java.lang.module.ModuleReference").getMethod("open", new Class[0]);
            Method list = Class.forName("java.lang.module.ModuleReader").getMethod("list", new Class[0]);
            modules.forEach(module -> {});
            for (Object module2 : modules) {
                Object ref = reference.invoke(module2, new Object[0]);
                try {
                    Closeable reader = (Closeable)open.invoke(ref, new Object[0]);
                    Throwable throwable = null;
                    try {
                        Stream stream = (Stream)list.invoke((Object)reader, new Object[0]);
                        stream.filter(ManateeClassScanner::isClass).forEach(className -> classes.add(className.substring(0, className.length() - 6).replace("/", ".")));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    private static List<String> scanDirectory(File dir, String packageName) {
        File[] files = dir.listFiles();
        ArrayList<String> classes = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (file.isDirectory()) {
                    classes.addAll(ManateeClassScanner.scanDirectory(file, packageName == null ? name : packageName + "." + name));
                    continue;
                }
                if (!name.endsWith(".class") || name.contains("$")) continue;
                classes.add(ManateeClassScanner.filterFullName(packageName + "." + name.substring(0, name.length() - 6)));
            }
        }
        return classes;
    }

    private static String filterFullName(String fullName) {
        if (fullName.startsWith("BOOT-INF.classes.")) {
            fullName = fullName.substring(17);
        }
        return fullName;
    }

    private static List<String> scanJarFile(URL url) {
        ArrayList<String> classes = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(url.openStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String className;
                if (entry.getName().contains("META-INF") || !ManateeClassScanner.isClass(className = entry.getName())) continue;
                classes.add(ManateeClassScanner.filterFullName(className.substring(0, className.length() - 6).replace("/", ".")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }

    private static boolean isClass(String className) {
        return className.endsWith(".class") && !className.contains("$") && !className.contains("module-info");
    }

    public static int asInt(Object val, int defaultValue) {
        try {
            if (val instanceof BigDecimal) {
                return ((BigDecimal)val).intValue();
            }
            return new BigDecimal(val.toString()).intValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

