/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.ManateeJavaSpringBeanUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.ProcessCheckUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RunJavaMethodProcess
implements IProcess {
    @Resource
    private ManateeJavaSpringBeanUtil manateeJavaSpringBeanUtil;
    @Resource
    protected ProcessConfUtil processConfUtil;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    protected InputUtil inputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"service", "method"});
        try {
            String callType = (String)content.getStepConf("callType");
            String service = ProcessCheckUtil.getParam((ProcessContent)content, (String)"service");
            String method = ProcessCheckUtil.getParam((ProcessContent)content, (String)"method");
            Object[] params = this.inputUtil.getHandleObjects(content);
            Object paramTypeObj = content.getStepConf("paramsType");
            JSONObject paramType = null;
            if (paramTypeObj instanceof JSONObject) {
                paramType = (JSONObject)paramTypeObj;
            } else {
                String paramTypeStr = paramTypeObj + "";
                if (StringUtil.isNotBlank((String)paramTypeStr)) {
                    paramType = this.inputUtil.getParamTypeByExp(paramTypeStr);
                }
            }
            Object data = null;
            if (StringUtil.isNotBlank((String)callType) && "enum".equals(callType)) {
                String atribute = ProcessCheckUtil.getParam((ProcessContent)content, (String)"atribute");
                data = this.manateeJavaSpringBeanUtil.invokeMethod(service, atribute, method, params);
            } else {
                data = this.manateeJavaSpringBeanUtil.invokeMethod(service, method, params, paramType);
            }
            data = JSONObject.toJSON((Object)data);
            this.outputUtil.handleAndPutData(content, data);
        }
        catch (Throwable e) {
            if (e instanceof BizException) {
                BizException bizException = (BizException)e;
                bizException.setInterrupt(Integer.valueOf(3));
                throw bizException;
            }
            BizException bizException = new BizException(ResultCode.SYSTEM_ERROR, e);
            if (StringUtil.isNotBlank((String)e.getMessage())) {
                bizException.setMsg(e.getMessage());
            }
            throw bizException;
        }
    }

    public String getName() {
        return "runJavaMethodProcess";
    }
}

