CREATE TABLE LOWCODE_LOGIC_BEHAVIOR (
  ID BIGINT PRIMARY KEY,
  PROJECT_ID BIGINT NOT NULL,
  MODULE_ID BIGINT DEFAULT NULL,
  LOGIC_ID BIGINT NOT NULL,
  BEHAVIOR_NAME VARCHAR2(32) NOT NULL,
  BEHAVIOR_CODE VARCHAR2(64) NOT NULL,
  BEHAVIOR_PINGYIN VARCHAR2(255) NOT NULL,
  DESCRIPTION VARCHAR2(255) DEFAULT NULL,
  CREATE_USER BIGINT DEFAULT NULL,
  GMT_CREATE TIMESTAMP DEFAULT NULL,
  MODIFIED_USER BIGINT DEFAULT NULL,
  GMT_MODIFIED TIMESTAMP DEFAULT NULL,
  VALID INT DEFAULT 0 NOT NULL,
  VALID_ID BIGINT DEFAULT NULL
);
create index idx_projectId_behaviorCode on LOWCODE_LOGIC_BEHAVIOR(PROJECT_ID, BEHAVIOR_CODE);
CREATE UNIQUE INDEX idx_logicId_behaviorCode_valid ON LOWCODE_LOGIC_BEHAVIOR (LOGIC_ID, BEHAVIOR_CODE, VALID, VALID_ID);