package ${package}.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.domain.WebResult;
import com.manatee.lowcode.util.WebUtil;
import com.manatee.lowcode.web.manager.CustomizeModuleManager;
import com.manatee.process.ProcessUtil;
import com.manatee.process.constant.ProcessConstant;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import lombok.AllArgsConstructor;
import ${package}.service.${upClassName}Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSONArray;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ${moduleName}服务实现
 *
 * @author ${author} ${email}
 * @since ${version} ${date}
 */
@Service
@AllArgsConstructor
public class ${upClassName}ServiceImpl implements ${upClassName}Service {

    private static final Logger log = LoggerFactory.getLogger(${upClassName}ServiceImpl.class);

    @Autowired
    private ProcessUtil processUtil;

    @Resource
    private WebUtil webUtil;

<#list moduleList as module>
    @Override
    public JSONObject ${module.moduleCode}Process(HttpServletRequest request, ProcessContent content){
        String code = content.getCode();
        if(code==null){
            code = request.getParameter(ProcessConstant.Key.CODE);
        }
        //流程多步循环处理
        try{
        <#if (module.processConf)??>
            JSONObject processConfJson = JSONObject.parseObject("${module.processConf?replace('\\','\\\\')?replace('"','\\\"')}");
        <#else >
            JSONObject processConfJson = JSONObject.parseObject("{\"steps\":[]}");
        </#if>
            JSONArray stepArray = processConfJson.getJSONArray("steps");
            for (int i = 0; i < stepArray.size(); i++) {
                JSONObject stepJson = stepArray.getJSONObject(i);
                if (null == stepJson || StringUtils.isEmpty(stepJson.getString("name"))){
                    continue;
                }
                Step step = new Step();
                step.setName(stepJson.getString("name"));
                step.setTitle(stepJson.getString("title"));
                step.setConf(stepJson);
                content.setStep(step);
                processUtil.getProcess(step.getName()).process(content);
            }
        }catch (BizException e){
            log.error(e.getMessage());
        }

        //返回值
        WebResult result = webUtil.wirteToResult(content);
        if (WebUtil.isSuccessResult(result)) {
            log.warn("[CustomizeModuleManager.customize]_success,code:{},projectId:{}"
            ,code,content.getProjectId());
        } else{
            String re = null;
            Object reJson = result.toJson();
            if(reJson!=null){
                re = reJson.toString();
                if(re.length()>500){
                    re = re.substring(0,200);
                }
            }
        log.error("[CustomizeModuleManager.customize]_biz_error,code:{},projectId:{},result:{}"
        ,code,content.getProjectId(),re);
        }
        return result.toJson();
    }
</#list>
}