/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.lock;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.process.impl.lock.ManateeLock;
import com.manatee.redis.config.ManateeRedissonConfig;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

@Service
public class ReidsLockImpl
implements ManateeLock {
    @Resource
    private ManateeRedissonConfig manateeRedissonConfig;

    public Boolean lock(Object key, String tryLockTimeOut, String lockTimeOut, String isFair) throws InterruptedException {
        RedissonClient redissonClient = this.manateeRedissonConfig.getRedissonClient();
        RLock lock = redissonClient.getLock(key.toString());
        if (StrUtil.isNotBlank((CharSequence)tryLockTimeOut) && StrUtil.isNotBlank((CharSequence)lockTimeOut)) {
            int tryLockTimeOutNum = Integer.parseInt(tryLockTimeOut);
            int lockTimeOutNum = Integer.parseInt(lockTimeOut);
            lock.tryLock((long)tryLockTimeOutNum, (long)lockTimeOutNum, TimeUnit.SECONDS);
        } else if (StrUtil.isNotBlank((CharSequence)tryLockTimeOut) && StrUtil.isBlank((CharSequence)lockTimeOut)) {
            int tryLockTimeOutNum = Integer.parseInt(tryLockTimeOut);
            lock.tryLock((long)tryLockTimeOutNum, TimeUnit.SECONDS);
        } else if (StrUtil.isBlank((CharSequence)tryLockTimeOut) && StrUtil.isNotBlank((CharSequence)lockTimeOut)) {
            lock.lock(1L, TimeUnit.SECONDS);
        } else {
            lock.lock();
        }
        return true;
    }

    public Boolean unLock(Object key) {
        RedissonClient redissonClient = this.manateeRedissonConfig.getRedissonClient();
        RLock lock = redissonClient.getLock(key.toString());
        lock.unlock();
        return true;
    }
}

