/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.FlowNode;

public class ProcessAllWay {
    private FlowNode baseNode;
    private List<Gateway> gatewayList = new ArrayList<Gateway>();

    public ProcessAllWay(FlowNode baseNode) {
        this.baseNode = baseNode;
    }

    public void addGateway(List<FlowNode> otherWayList, FlowNode gatewayNode) {
        Gateway gateWay = new Gateway(this.baseNode);
        gateWay.otherWayList.addAll(otherWayList);
        gateWay.setGatewayNode(gatewayNode);
        this.gatewayList.add(gateWay);
    }

    private ProcessAllWay() {
    }

    public FlowNode getBaseNode() {
        return this.baseNode;
    }

    public List<Gateway> getGatewayList() {
        return this.gatewayList;
    }

    public void setBaseNode(FlowNode baseNode) {
        this.baseNode = baseNode;
    }

    public void setGatewayList(List<Gateway> gatewayList) {
        this.gatewayList = gatewayList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessAllWay)) {
            return false;
        }
        ProcessAllWay other = (ProcessAllWay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FlowNode this$baseNode = this.getBaseNode();
        FlowNode other$baseNode = other.getBaseNode();
        if (this$baseNode == null ? other$baseNode != null : !this$baseNode.equals(other$baseNode)) {
            return false;
        }
        List<Gateway> this$gatewayList = this.getGatewayList();
        List<Gateway> other$gatewayList = other.getGatewayList();
        return !(this$gatewayList == null ? other$gatewayList != null : !((Object)this$gatewayList).equals(other$gatewayList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessAllWay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FlowNode $baseNode = this.getBaseNode();
        result = result * 59 + ($baseNode == null ? 43 : $baseNode.hashCode());
        List<Gateway> $gatewayList = this.getGatewayList();
        result = result * 59 + ($gatewayList == null ? 43 : ((Object)$gatewayList).hashCode());
        return result;
    }

    public String toString() {
        return "ProcessAllWay(baseNode=" + this.getBaseNode() + ", gatewayList=" + this.getGatewayList() + ")";
    }

    public static class Gateway {
        private Map<FlowNode, List<Gateway>> exclusiveGatewayMap = new HashMap<FlowNode, List<Gateway>>();
        private List<Gateway> gatewayList = new ArrayList<Gateway>();
        private FlowNode baseNode;
        private FlowNode gatewayNode;
        private List<FlowNode> otherWayList = new ArrayList<FlowNode>();

        public Gateway(FlowNode baseNode) {
            this.baseNode = baseNode;
        }

        public void add(FlowNode flowNode) {
            this.otherWayList.add(flowNode);
            for (Gateway gateway : this.gatewayList) {
                gateway.add(flowNode);
            }
        }

        public void remove(FlowNode flowNode) {
            this.otherWayList.remove(flowNode);
            for (Gateway gateway : this.gatewayList) {
                gateway.remove(flowNode);
            }
        }

        public Map<FlowNode, List<Gateway>> getExclusiveGatewayMap() {
            return this.exclusiveGatewayMap;
        }

        public void setExclusiveGatewayMap(Map<FlowNode, List<Gateway>> exclusiveGatewayMap) {
            this.exclusiveGatewayMap = exclusiveGatewayMap;
        }

        public FlowNode getBaseNode() {
            return this.baseNode;
        }

        public void setBaseNode(FlowNode baseNode) {
            this.baseNode = baseNode;
        }

        public FlowNode getGatewayNode() {
            return this.gatewayNode;
        }

        public void setGatewayNode(FlowNode gatewayNode) {
            this.gatewayNode = gatewayNode;
        }

        public List<Gateway> getGatewayList() {
            return this.gatewayList;
        }

        public void setGatewayList(List<Gateway> gatewayList) {
            this.gatewayList = gatewayList;
        }

        public List<FlowNode> getOtherWayList() {
            return this.otherWayList;
        }

        public void setOtherWayList(List<FlowNode> otherWayList) {
            this.otherWayList = otherWayList;
        }
    }
}

