/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.dmn;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.springframework.stereotype.Service;

@Service
public class CamundaGetDmnProcess
implements IProcess {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        DecisionDefinition decisionDefinition;
        DecisionDefinitionQuery decisionDefinitionQuery = this.repositoryService.createDecisionDefinitionQuery();
        String key = this.variableUtil.calVarInConf(content, "key");
        if (StrUtil.isNotBlank((CharSequence)key)) {
            decisionDefinitionQuery.decisionDefinitionKey(key);
        }
        if ((decisionDefinition = (DecisionDefinition)decisionDefinitionQuery.latestVersion().singleResult()) == null) {
            return;
        }
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(decisionDefinition.getDeploymentId()).singleResult();
        InputStream bpmn = this.repositoryService.getResourceAsStream(decisionDefinition.getDeploymentId(), decisionDefinition.getResourceName());
        String dmnSrt = IoUtil.read((InputStream)bpmn, (Charset)Charset.defaultCharset());
        JSONObject result = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)decisionDefinition.getDiagramResourceName())) {
            InputStream svg = this.repositoryService.getResourceAsStream(decisionDefinition.getDeploymentId(), decisionDefinition.getDiagramResourceName());
            String svgSrt = IoUtil.read((InputStream)svg, (Charset)Charset.defaultCharset());
            result.put("pic", (Object)svgSrt);
        }
        result.put("id", (Object)deployment.getId());
        result.put("name", (Object)deployment.getName());
        result.put("dmn", (Object)dmnSrt);
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "camundaGetDmnProcess";
    }
}

