/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.constant;

public enum TaskStatusEnum {
    RUN(1, "\u8fd0\u884c\u4e2d", ""),
    TASK_RETURN(2, "\u5df2\u9000\u56de", "return@@:"),
    TASK_WITHDRAW(3, "\u5df2\u53d6\u56de", "withdraw@@:"),
    TASK_FORWARD(3, "\u5df2\u8f6c\u4ea4", "forward@@:"),
    TASK_REFUSE(10, "\u5df2\u62d2\u7edd", "refuse@@:"),
    TASK_REVOKE(11, "\u5df2\u64a4\u9500", "revoke@@:");

    public int processStatus;
    public String statusName;
    public String statusCode;

    public static TaskStatusEnum getProcessStatusEnum(String code) {
        for (TaskStatusEnum status : TaskStatusEnum.values()) {
            if (status.getStatusCode().equals("") || !code.startsWith(status.getStatusCode())) continue;
            return status;
        }
        return RUN;
    }

    public static String[] getProcessStatusCodes() {
        String[] result = new String[TaskStatusEnum.values().length];
        for (int i = 0; i < TaskStatusEnum.values().length; ++i) {
            result[i] = TaskStatusEnum.values()[i].getStatusCode();
        }
        return result;
    }

    private TaskStatusEnum(int processStatus, String statusName, String statusCode) {
        this.processStatus = processStatus;
        this.statusName = statusName;
        this.statusCode = statusCode;
    }

    public int getProcessStatus() {
        return this.processStatus;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getStatusCode() {
        return this.statusCode;
    }
}

