/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.constant;

public enum ProcessStatusEnum {
    RUN(1, "\u8fd0\u884c\u4e2d", ""),
    REFUS(10, "\u5df2\u62d2\u7edd", "refuse@@:"),
    REVOKE(11, "\u5df2\u64a4\u9500", "revoke@@:");

    public int processStatus;
    public String statusName;
    public String statusCode;

    public static ProcessStatusEnum getProcessStatusEnum(String code) {
        if (code == null) {
            return RUN;
        }
        for (ProcessStatusEnum status : ProcessStatusEnum.values()) {
            if (status.getStatusCode().equals("") || !code.startsWith(status.getStatusCode())) continue;
            return status;
        }
        return RUN;
    }

    public static String[] getProcessStatusCodes() {
        String[] result = new String[ProcessStatusEnum.values().length];
        for (int i = 0; i < ProcessStatusEnum.values().length; ++i) {
            result[i] = ProcessStatusEnum.values()[i].getStatusCode();
        }
        return result;
    }

    private ProcessStatusEnum(int processStatus, String statusName, String statusCode) {
        this.processStatus = processStatus;
        this.statusName = statusName;
        this.statusCode = statusCode;
    }

    public int getProcessStatus() {
        return this.processStatus;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getStatusCode() {
        return this.statusCode;
    }
}

