/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.memcached.config;

import com.manatee.memcached.config.MemcachedClientCondition;
import com.manatee.memcached.config.MemcachedClientManagerAbstract;
import com.manatee.memcached.config.MemcachedClientManagerAbstractCondition;
import com.manatee.memcached.config.MemcachedClientManagerImpl;
import com.manatee.memcached.config.XMemcachedProperties;
import java.io.IOException;
import javax.annotation.Resource;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MemcachedBuilder {
    private Logger LOGGER = LoggerFactory.getLogger(MemcachedBuilder.class);
    @Resource
    private XMemcachedProperties xMemcachedProperties;

    @Bean
    @Conditional(value={MemcachedClientCondition.class})
    public MemcachedClient getMemcachedClinet(MemcachedClientManagerAbstract memcachedClientManagerAbstract) {
        MemcachedClient memcachedClient = memcachedClientManagerAbstract.getMemcachedClient();
        if (memcachedClient != null) {
            return memcachedClient;
        }
        try {
            XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)this.xMemcachedProperties.getServers()));
            builder.setConnectionPoolSize(this.xMemcachedProperties.getPoolSize());
            builder.setOpTimeout(this.xMemcachedProperties.getOpTimeout());
            memcachedClient = builder.build();
        }
        catch (IOException e) {
            this.LOGGER.error("init MemcachedClient failed" + e);
        }
        return memcachedClient;
    }

    @Bean
    @Conditional(value={MemcachedClientManagerAbstractCondition.class})
    public MemcachedClientManagerAbstract getMemcachedClientManagerAbstract() {
        return new MemcachedClientManagerImpl();
    }
}

