/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.java.springCompiler;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import javax.tools.JavaFileManager;

public class ManateeSpringJavaFileManager
extends JavacFileManager {
    public ManateeSpringJavaFileManager(Context context, boolean b, Charset charset) {
        super(context, b, charset);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        ManateeSpringJavaFileManager.nullCheck(location);
        Iterable<? extends File> locationList = this.getLocation(location);
        if (locationList == null) {
            return null;
        }
        ListBuffer<URL> listBuffer = new ListBuffer<URL>();
        for (File file : locationList) {
            try {
                listBuffer.append(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.getClassLoader(listBuffer.toArray(new URL[listBuffer.size()]));
    }

    @Override
    protected ClassLoader getClassLoader(URL[] urlArr) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Class<?> loaderClass = Class.forName("org.springframework.boot.loader.LaunchedURLClassLoader");
            Class[] urlAndClassLoaderClassArr = new Class[]{URL[].class, ClassLoader.class};
            Constructor<?> constructor = loaderClass.getConstructor(urlAndClassLoaderClassArr);
            return (ClassLoader)constructor.newInstance(urlArr, classLoader);
        }
        catch (Throwable throwable) {
            return new URLClassLoader(urlArr, classLoader);
        }
    }
}

