/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.store.mysql;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransactionProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(TransactionProcess.class);
    @Resource
    protected ManateeDataSource manateeDataSource;
    @Resource
    private ProcessChain processChain;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"steps"});
        String db = this.variableUtil.calVarInConf(content, "db");
        String transactionIsolationLevel = this.variableUtil.calVarInConf(content, "transactionIsolationLevel");
        JSONObject conf = content.getStepConf();
        Connection transactionCon = null;
        boolean opneTransactionConFlag = false;
        try {
            if (content.getTransactionCon() == null) {
                opneTransactionConFlag = true;
                transactionCon = this.manateeDataSource.getConnection(db);
                transactionCon.setAutoCommit(false);
            } else {
                transactionCon = content.getTransactionCon();
            }
            if (StringUtils.isNotBlank((CharSequence)transactionIsolationLevel)) {
                int isolationLevel = 0;
                switch (transactionIsolationLevel) {
                    case "read_uncommitted": {
                        isolationLevel = 1;
                        break;
                    }
                    case "read_committed": {
                        isolationLevel = 2;
                        break;
                    }
                    case "repeatable_read": {
                        isolationLevel = 4;
                        break;
                    }
                    case "serializable": {
                        isolationLevel = 8;
                        break;
                    }
                }
                transactionCon.setTransactionIsolation(isolationLevel);
            }
            content.setTransactionCon(transactionCon);
            this.doSteps(content, conf);
        }
        catch (Throwable e) {
            try {
                this.log.warn("\u53d1\u751f\u5f02\u5e38\uff0c\u4e8b\u52a1\u56de\u6eda");
                transactionCon.rollback();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            finally {
                try {
                    if (transactionCon != null) {
                        transactionCon.close();
                        this.log.warn("\u4e8b\u52a1\u6570\u636e\u5e93\u94fe\u63a5\u5173\u95ed");
                    }
                }
                catch (SQLException sqlException) {
                    sqlException.printStackTrace();
                }
            }
            BizException bizException = null;
            if (e instanceof BizException) {
                bizException = (BizException)e;
                throw bizException;
            }
            bizException = new BizException(ResultCode.BIZ_ERROR, "cal_transactionProcess_error", e);
            String id = conf.getString("id");
            String title = conf.getString("title");
            bizException.setId(id);
            bizException.setStepName("transactionProcess");
            bizException.setStepTitle(title);
            throw bizException;
        }
        try {
            if (opneTransactionConFlag) {
                this.log.info("\u63d0\u4ea4\u4e8b\u52a1");
                transactionCon.commit();
            }
        }
        catch (SQLException throwables) {
            this.log.error("transactionCon commit error", (Throwable)throwables);
        }
        finally {
            try {
                if (transactionCon != null && opneTransactionConFlag) {
                    transactionCon.close();
                    content.setTransactionCon(null);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void doSteps(ProcessContent content, JSONObject conf) throws BizException {
        List steps = ProcessDataSource.formatSteps((JSONObject)conf);
        this.processChain.executeSteps(content, steps);
    }

    public String getName() {
        return "transactionProcess";
    }
}

