/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.log;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.log.LogBean;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ProcessLog {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessLog.class);
    private static Logger KAFKA_LOGGER = LoggerFactory.getLogger((String)"kafka");
    @Resource
    private ManateeConfig manateeConfig;

    @Pointcut(value="execution(public * com.manatee.process.IProcess.process(..))")
    public void processLog() {
    }

    @Around(value="processLog()")
    public void doProcessLog(ProceedingJoinPoint point) throws Throwable {
        String traceId = MDC.get((String)"traceId");
        String kafkaHost = this.manateeConfig.getLog().getKafka().getHost();
        if (StringUtil.isNotBlank((String)kafkaHost)) {
            Object[] args = point.getArgs();
            ProcessContent content = (ProcessContent)args[0];
            long startTime = System.currentTimeMillis();
            point.proceed();
            long time = System.currentTimeMillis() - startTime;
            JSONObject tempContext = (JSONObject)content.getRequest().get("tempContext");
            Long userId = null;
            Long projectId = null;
            if (tempContext != null) {
                userId = tempContext.getLong("userId");
                projectId = tempContext.getLong("projectId");
            }
            LogBean logBean = new LogBean(traceId, userId, (String)content.getModule("name"), (String)content.getModule("lowcodeModule"), time);
            logBean.setStepTitle(content.getStep().getTitle());
            logBean.setStepName(content.getStep().getName());
            logBean.setProjectId(projectId);
            KAFKA_LOGGER.info(JSONObject.toJSONString((Object)logBean));
        } else if (StrUtil.isNotBlank((CharSequence)traceId) && traceId.startsWith("D-")) {
            point.proceed();
        } else {
            Object[] args = point.getArgs();
            ProcessContent content = (ProcessContent)args[0];
            long startTime = System.currentTimeMillis();
            point.proceed();
            long time = System.currentTimeMillis() - startTime;
            LOGGER.debug("\u8bf7\u6c42ID:\u3010{}\u3011,\u63a5\u53e3\u540d\u79f0:\u3010{}\u3011,\u63a5\u53e3\u5730\u5740:\u3010{}\u3011, \u7ec4\u4ef6\u540d\u79f0:\u3010{}\u3011,\u7ec4\u4ef6\u51fa\u53c2:\u3010{}\u3011, \u6267\u884c\u8017\u65f6:\u3010{}\u3011\u6beb\u79d2", new Object[]{content.getTraceId(), content.getModule("name"), content.getModule("url"), StringUtil.isNotBlank((String)content.getStep().getTitle()) ? content.getStep().getTitle() : content.getStep().getName(), content.getResponse(), time});
        }
    }
}

