/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.other;

import com.manatee.common.exception.BizException;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.process.util.ManateeSpringBeanUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RunMethodFun
extends AbstractFunction {
    @Resource
    private ManateeSpringBeanUtil manateeSpringBeanUtil;

    public String getName() {
        return "runMethod";
    }

    public Object doFunction(FunctionContent content) {
        Object[] params;
        this.checkParamSize(content);
        Object result = null;
        List parameters = content.getParameters();
        if (parameters == null || parameters.size() < 2) {
            return result;
        }
        Object service = parameters.get(0);
        Object method = parameters.get(1);
        if (parameters.size() > 2) {
            List paramsList = parameters.subList(2, parameters.size());
            params = paramsList.toArray();
        } else {
            params = new Object[]{};
        }
        try {
            result = this.manateeSpringBeanUtil.invokeMethod(service.toString(), method.toString(), params);
            return result;
        }
        catch (BizException e) {
            e.printStackTrace();
            return result;
        }
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return Integer.MAX_VALUE;
    }
}

