/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.other;

import com.manatee.common.util.tool.core.img.ImgUtil;
import com.manatee.common.util.tool.core.io.FileUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.lowcode.manager.FileUploadManager;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.lowcode.util.qrcode.QrCodeUtil;
import com.manatee.lowcode.util.qrcode.QrConfig;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class QrCodeFun
extends AbstractFunction {
    @Resource
    private FileUploadManager fileUploadManager;

    public String getName() {
        return "qrCode";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        this.checkParamExist(content);
        List parameters = content.getParameters();
        String link = (String)parameters.get(0);
        String bucketName = (String)parameters.get(1);
        String folder = parameters.size() > 2 ? (String)parameters.get(2) : "";
        try {
            if (parameters.size() > 3) {
                String logoUrl = (String)parameters.get(3);
                return this.generateQrCodeWithLogo(link, logoUrl, bucketName, folder);
            }
            return this.generateQrCode(link, bucketName, folder);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 4;
    }

    private String generateQrCodeWithLogo(String link, String logoUrl, String bucketName, String folder) throws Exception {
        URI logoURI = URI.create(logoUrl);
        InputStream logoInputStream = logoURI.toURL().openStream();
        BufferedImage logoImage = ImgUtil.read((InputStream)logoInputStream);
        File qrCodeFile = this.getQrCodeFile();
        QrCodeUtil.generate(link, QrConfig.create().setImg(logoImage), qrCodeFile);
        String url = this.fileUploadManager.uploadFile(new FileInputStream(qrCodeFile), bucketName, folder, "jpg");
        FileUtil.del((File)qrCodeFile);
        return url;
    }

    private String generateQrCode(String link, String bucketName, String folder) throws Exception {
        File qrCodeFile = this.getQrCodeFile();
        QrCodeUtil.generate(link, 300, 300, qrCodeFile);
        String url = this.fileUploadManager.uploadFile(new FileInputStream(qrCodeFile), bucketName, folder, "jpg");
        FileUtil.del((File)qrCodeFile);
        return url;
    }

    private File getQrCodeFile() {
        if (!FileUtil.exist((String)GlobalConf.TEMP_DIRECTORY)) {
            FileUtil.mkdir((String)GlobalConf.TEMP_DIRECTORY);
        }
        File qrCodeFile = FileUtil.file((String)(GlobalConf.TEMP_DIRECTORY + System.currentTimeMillis() + ".jpg"));
        return qrCodeFile;
    }
}

