/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.sql;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.SqlFormatter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    public static String buildEqualsWhere(DbEntity entity, List<Object> paramValues) {
        if (null == entity || entity.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        boolean isNotFirst = false;
        for (Map.Entry entry : entity.entrySet()) {
            if (isNotFirst) {
                sb.append(" and ");
            } else {
                isNotFirst = true;
            }
            sb.append("`").append((String)entry.getKey()).append("`").append(" = ?");
            paramValues.add(entry.getValue());
        }
        return sb.toString();
    }

    public static Condition[] buildConditions(DbEntity entity) {
        if (null == entity || entity.isEmpty()) {
            return null;
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>(entity.size());
        boolean i = false;
        for (Map.Entry entry : entity.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Condition) {
                conditions.add((Condition)((Object)value));
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList conditionList = (ArrayList)value;
                if (!CollUtil.isNotEmpty((Collection)conditionList)) continue;
                for (Object item : conditionList) {
                    conditions.add((Condition)((Object)item));
                }
                continue;
            }
            conditions.add(new Condition((String)entry.getKey(), value));
        }
        return conditions.toArray(new Condition[conditions.size()]);
    }

    public static String buildLikeValue(String value, Condition.LikeType likeType, boolean withLikeKeyword) {
        if (null == value) {
            return null;
        }
        StringBuilder likeValue = StrUtil.builder((CharSequence[])new CharSequence[]{withLikeKeyword ? "LIKE " : ""});
        switch (likeType) {
            case StartWith: {
                likeValue.append(value).append('%');
                break;
            }
            case EndWith: {
                likeValue.append('%').append(value);
                break;
            }
            case Contains: {
                likeValue.append('%').append(value).append('%');
                break;
            }
        }
        return likeValue.toString();
    }

    public static String buildNotLikeValue(String value, Condition.NotLikeType notLikeType, boolean withLikeKeyword) {
        if (null == value) {
            return null;
        }
        StringBuilder likeValue = StrUtil.builder((CharSequence[])new CharSequence[]{withLikeKeyword ? "NOT LIKE " : ""});
        switch (notLikeType) {
            case Does_Not_StartWith: {
                likeValue.append(value).append('%');
                break;
            }
            case Does_Not_EndWith: {
                likeValue.append('%').append(value);
                break;
            }
            case Does_Not_Contain: {
                likeValue.append('%').append(value).append('%');
                break;
            }
        }
        return likeValue.toString();
    }

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }

    public static String rowIdToString(RowId rowId) {
        return StrUtil.str((byte[])rowId.getBytes(), (Charset)CharsetUtil.CHARSET_ISO_8859_1);
    }

    public static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IoUtil.read((Reader)reader);
            return string;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            IoUtil.close((Closeable)reader);
        }
    }

    public static String blobToStr(Blob blob, Charset charset) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string = IoUtil.read((InputStream)in, (Charset)charset);
            return string;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            IoUtil.close((Closeable)in);
        }
    }

    public static Blob createBlob(Connection conn, InputStream dataStream, boolean closeAfterUse) {
        Blob blob;
        OutputStream out = null;
        try {
            blob = conn.createBlob();
            out = blob.setBinaryStream(1L);
            IoUtil.copy((InputStream)dataStream, (OutputStream)out);
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(out);
                if (closeAfterUse) {
                    IoUtil.close((Closeable)dataStream);
                }
                throw throwable;
            }
        }
        IoUtil.close((Closeable)out);
        if (closeAfterUse) {
            IoUtil.close((Closeable)dataStream);
        }
        return blob;
    }

    public static Blob createBlob(Connection conn, byte[] data) {
        Blob blob;
        try {
            blob = conn.createBlob();
            blob.setBytes(0L, data);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return blob;
    }

    public static Date toSqlDate(java.util.Date date) {
        return new Date(date.getTime());
    }

    public static Timestamp toSqlTimestamp(java.util.Date date) {
        return new Timestamp(date.getTime());
    }
}

