/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.ds.AbstractDSFactory;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;

public class DruidDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 4680621702534433222L;
    public static final String DS_NAME = "Druid";

    public DruidDSFactory() {
        this((HashMap<String, String>)null);
    }

    public DruidDSFactory(HashMap<String, String> setting) {
        super(DS_NAME, DruidDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, HashMap<String, String> poolSetting) {
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(jdbcUrl);
        ds.setDriverClassName(driver);
        ds.setUsername(user);
        ds.setPassword(pass);
        for (String key2 : KEY_CONN_PROPS) {
            String connValue = poolSetting.get(key2);
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            ds.addConnectionProperty(key2, connValue);
        }
        Properties druidProps = new Properties();
        poolSetting.forEach((key, value) -> druidProps.put(StrUtil.addPrefixIfNot((CharSequence)key, (CharSequence)"druid."), value));
        ds.configFromPropety(druidProps);
        String connectionErrorRetryAttemptsKey = "druid.connectionErrorRetryAttempts";
        if (druidProps.containsKey("druid.connectionErrorRetryAttempts")) {
            ds.setConnectionErrorRetryAttempts(((Integer)druidProps.get("druid.connectionErrorRetryAttempts")).intValue());
        }
        String timeBetweenConnectErrorMillisKey = "druid.timeBetweenConnectErrorMillis";
        if (druidProps.containsKey("druid.timeBetweenConnectErrorMillis")) {
            ds.setTimeBetweenConnectErrorMillis((long)((Integer)druidProps.get("druid.timeBetweenConnectErrorMillis")).intValue());
        }
        String breakAfterAcquireFailureKey = "druid.breakAfterAcquireFailure";
        if (druidProps.containsKey("druid.breakAfterAcquireFailure")) {
            ds.setBreakAfterAcquireFailure(((Boolean)druidProps.get("druid.breakAfterAcquireFailure")).booleanValue());
        }
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }
}

