/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.base;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBUpdate;
import com.manatee.common.domain.In;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.handle.DBHandleUtil;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBWriteBase {
    private Logger log = LoggerFactory.getLogger(DBWriteBase.class);
    @Resource
    protected ManateeDataSource manateeDataSource;
    @Resource
    private DBHandleUtil dbHandleUtil;
    private String INDEX = "index";

    protected JSONObject insert(DBInsert insert, Connection con, PreparedStatement ps) throws SQLException, BizException {
        DBHandle dbHandle;
        if (insert.getInsertColumns() == null) {
            List list = insert.getInsertColumnsBatch();
            if (list == null || list.size() == 0) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "insert_data_is_null");
            }
            Map aMap = (Map)list.get(0);
            insert.setInsertColumns(aMap);
        }
        if ((dbHandle = this.dbHandleUtil.getDBHandle(insert.getDatabaseProductName())) == null) {
            return null;
        }
        StringBuilder sqlSB = dbHandle.initInsertConditionSql(insert, con);
        ps = dbHandle.getPreparedStatement(con, sqlSB);
        StringBuilder executeSqlSb = new StringBuilder(sqlSB);
        this.initInsertConditionParam(executeSqlSb, insert, ps);
        insert.setExecuteSql(executeSqlSb.toString());
        int insertNum = dbHandle.executeInsert(ps, insert);
        JSONObject result = new JSONObject();
        dbHandle.handleInsertResult(insert, con, ps, result, insertNum);
        return result;
    }

    protected int update(DBUpdate dbUpdate, Connection con, PreparedStatement ps) throws SQLException, BizException {
        if ((dbUpdate.getQueryCondition() == null || dbUpdate.getQueryCondition().size() == 0) && StringUtil.isBlank((String)dbUpdate.getCondition()) && dbUpdate.getIn() == null) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "input_db_query_is_null");
        }
        if (dbUpdate.getUpdateColumns() == null || dbUpdate.getUpdateColumns().size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "update_data_is_null");
        }
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(dbUpdate.getDatabaseProductName());
        StringBuilder sqlSB = new StringBuilder("update ");
        sqlSB = dbHandle.initAppendTableSql(sqlSB, dbUpdate.getTable(), con);
        sqlSB.append(" set ");
        sqlSB = this.initUpdateColumns(dbUpdate, sqlSB);
        sqlSB = this.initQueryConditionSql(dbUpdate, sqlSB);
        sqlSB = this.initConditionSql(dbUpdate, sqlSB);
        sqlSB = this.initInSql(dbUpdate, sqlSB);
        ps = con.prepareStatement(sqlSB.toString());
        StringBuilder executeSqlSb = new StringBuilder(sqlSB);
        this.initConditionParam(executeSqlSb, dbUpdate, ps);
        this.initInParam(executeSqlSb, dbUpdate, ps);
        dbUpdate.setExecuteSql(executeSqlSb.toString());
        int data = ps.executeUpdate();
        return data;
    }

    protected int delete(DBUpdate dbDelete, Connection con, PreparedStatement ps) throws SQLException, BizException {
        if (dbDelete.getQueryCondition() == null || dbDelete.getQueryCondition().size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "input_db_query_is_null");
        }
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(dbDelete.getDatabaseProductName());
        StringBuilder sqlSB = new StringBuilder("delete from ");
        sqlSB = dbHandle.initAppendTableSql(sqlSB, dbDelete.getTable(), con);
        sqlSB = this.initQueryConditionSql(dbDelete, sqlSB);
        sqlSB = this.initConditionSql(dbDelete, sqlSB);
        sqlSB = this.initInSql(dbDelete, sqlSB);
        ps = con.prepareStatement(sqlSB.toString());
        StringBuilder executeSqlSb = new StringBuilder(sqlSB);
        this.initConditionParam(executeSqlSb, dbDelete, ps);
        this.initInParam(executeSqlSb, dbDelete, ps);
        dbDelete.setExecuteSql(executeSqlSb.toString());
        int data = ps.executeUpdate();
        return data;
    }

    private StringBuilder initUpdateColumns(DBUpdate dbUpdate, StringBuilder sqlSB) {
        Map columns = dbUpdate.getUpdateColumns();
        if (columns != null && columns.size() != 0) {
            for (Map.Entry aMap : columns.entrySet()) {
                Object value = aMap.getValue();
                if (value == null) continue;
                sqlSB.append((String)aMap.getKey()).append("=?").append(",");
            }
            sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 1));
        }
        return sqlSB;
    }

    private StringBuilder initConditionSql(DBUpdate dbUpdate, StringBuilder sqlSB) {
        String conditionSql = dbUpdate.getCondition();
        if (StringUtil.isBlank((String)conditionSql)) {
            return sqlSB;
        }
        if (sqlSB.indexOf("where") == -1) {
            sqlSB.append(" where ");
        } else if (!sqlSB.toString().endsWith(" where ")) {
            sqlSB.append(" and ");
        }
        sqlSB.append(conditionSql);
        return sqlSB;
    }

    private StringBuilder initQueryConditionSql(DBUpdate dbUpdate, StringBuilder sqlSB) {
        Map condition = dbUpdate.getQueryCondition();
        if (condition != null && condition.size() != 0) {
            sqlSB.append(" where ");
            boolean needAnd = false;
            for (Map.Entry aMap : condition.entrySet()) {
                Object value = aMap.getValue();
                if (value == null) continue;
                if (needAnd) {
                    sqlSB.append(" and ").append((String)aMap.getKey()).append("=?");
                    continue;
                }
                sqlSB.append((String)aMap.getKey()).append("=?");
                needAnd = true;
            }
        }
        return sqlSB;
    }

    private StringBuilder initInSql(DBUpdate dbUpdate, StringBuilder sqlSB) {
        List inList = dbUpdate.getIn();
        if (inList == null || inList.size() == 0) {
            return sqlSB;
        }
        StringBuilder inCondition = new StringBuilder();
        for (In in : inList) {
            if (in == null) continue;
            List list = in.getValue();
            String key = in.getKey();
            if (key == null) continue;
            boolean filterEmptyInValue = in.isFilterEmptyValue();
            if ((list == null || list.isEmpty()) && filterEmptyInValue) continue;
            inCondition.append(key);
            inCondition.append(" in (");
            for (Object value : list) {
                if (value == null) continue;
                inCondition.append("?,");
            }
            String str = inCondition.substring(0, inCondition.toString().endsWith(",") ? inCondition.length() - 1 : inCondition.length());
            inCondition = new StringBuilder(str);
            inCondition.append(") and ");
        }
        if (inCondition != null && !"".equals(inCondition) && inCondition.toString().endsWith(" and ")) {
            if (sqlSB.indexOf("where") == -1) {
                sqlSB.append(" where ");
            }
            if (sqlSB.length() - sqlSB.lastIndexOf("where ") != "where ".length()) {
                sqlSB.append(" and ");
            }
            StringBuilder result = new StringBuilder(inCondition.substring(0, inCondition.length() - 5));
            return sqlSB.append((CharSequence)result);
        }
        return sqlSB;
    }

    private void initInsertConditionParam(StringBuilder sqlSb, DBInsert insert, PreparedStatement ps) throws SQLException {
        block4: {
            Map insertColumns;
            int index;
            block3: {
                index = 1;
                insertColumns = insert.getInsertColumns();
                String sql = sqlSb.toString().replaceAll("\\?", "###WH###");
                sqlSb.delete(0, sqlSb.length());
                sqlSb.append(sql);
                if (!insert.isBatch()) break block3;
                List insertBatchColumns = insert.getInsertColumnsBatch();
                for (Map insertBatchColumn : insertBatchColumns) {
                    for (Map.Entry aMap : insertColumns.entrySet()) {
                        Object value = insertBatchColumn.get(aMap.getKey());
                        this.initParamInPS(sqlSb, ps, index, value);
                        ++index;
                    }
                }
                break block4;
            }
            if (insertColumns == null || insertColumns.size() == 0) break block4;
            for (Map.Entry aMap : insertColumns.entrySet()) {
                Object value = aMap.getValue();
                if (value == null) continue;
                value = this.dataFromat(value);
                this.initParamInPS(sqlSb, ps, index, value);
                ++index;
            }
        }
    }

    private void initConditionParam(StringBuilder sqlSb, DBUpdate dbUpdate, PreparedStatement ps) throws SQLException {
        Map updateColumns = dbUpdate.getUpdateColumns();
        Map queryCondition = dbUpdate.getQueryCondition();
        ArrayList data = new ArrayList();
        if (updateColumns != null && updateColumns.size() != 0) {
            for (Map.Entry aMap : updateColumns.entrySet()) {
                data.add(aMap.getValue());
            }
        }
        if (queryCondition != null && queryCondition.size() != 0) {
            for (Map.Entry aMap : queryCondition.entrySet()) {
                data.add(aMap.getValue());
            }
        }
        int index = 1;
        if (data != null && data.size() != 0) {
            for (Object value : data) {
                if (value == null) continue;
                value = this.dataFromat(value);
                this.initParamInPS(sqlSb, ps, index, value);
                ++index;
            }
        }
        dbUpdate.putTemp(this.INDEX, (Object)index);
    }

    private void initInParam(StringBuilder sqlSb, DBUpdate dbUpdate, PreparedStatement ps) throws SQLException {
        List inList = dbUpdate.getIn();
        if (inList == null || inList.size() == 0) {
            return;
        }
        for (In in : inList) {
            List list = in.getValue();
            String key = in.getKey();
            if (list == null || key == null) {
                return;
            }
            Integer index = (Integer)dbUpdate.getTemp(this.INDEX);
            for (Object value : list) {
                if (value == null) continue;
                this.initParamInPS(sqlSb, ps, index, value);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            dbUpdate.putTemp(this.INDEX, (Object)index);
        }
    }

    private void initParamInPS(StringBuilder sqlSb, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value instanceof Integer) {
            ps.setInt(index, (Integer)value);
        } else if (value instanceof Long) {
            ps.setLong(index, (Long)value);
        } else if (value == null) {
            ps.setNull(index, 0);
        } else if (value instanceof Date) {
            Date date = (Date)value;
            ps.setTimestamp(index, new Timestamp(date.getTime()));
        } else if (value instanceof byte[]) {
            ps.setBytes(index, (byte[])value);
        } else {
            ps.setString(index, value + "");
        }
        String sql = sqlSb.toString().replaceFirst("###WH###", value instanceof String ? "'" + Matcher.quoteReplacement(value.toString()) + "'" : Matcher.quoteReplacement(JSONObject.toJSONString((Object)value)));
        sqlSb.delete(0, sqlSb.length());
        sqlSb.append(sql);
    }

    private Object dataFromat(Object obj) {
        if (obj instanceof Map || obj instanceof List) {
            return JSONObject.toJSON((Object)obj);
        }
        return obj;
    }

    public Map<String, Object> convertMap(ResultSet rs) throws SQLException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            Object obj = rs.getObject(i);
            if (obj instanceof BigInteger) {
                obj = Long.valueOf(obj + "");
            }
            map.put(md.getColumnName(i), obj);
        }
        return map;
    }
}

