/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mtop.filter.source;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.SourceCode;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IDbReadUtil;
import com.manatee.mtop.filter.handle.domain.MtopData;
import com.manatee.mtop.filter.handle.domain.MtopResult;
import com.manatee.mtop.filter.source.MtopDataSource;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service(value="mtopDataSourceImpl")
public class MtopDataSourceImpl
implements MtopDataSource {
    private final String SESSION_CONF = "conf:loginUrlConf";
    private final String CUSTOMIZE_URL = "/biz/customizeModule.do";
    private final String FILTER_URL = "/biz/register,/biz/login,/biz/license.do";
    private final String LOCAL_IMAGE_URL = "/biz/image/";
    private final String STATIC_RESOURCE = "/server-static/";
    @Resource
    private IDbReadUtil dbReadUtil;

    private JSONObject getUrlConf(String key) {
        JSONObject confJson = new JSONObject();
        JSONObject notLoginConf = new JSONObject();
        notLoginConf.put("/biz/login", (Object)"1");
        notLoginConf.put("/biz/customizeModule.do?lowcodeModule=userRegister", (Object)"1");
        JSONObject urlConf = new JSONObject();
        urlConf.put("notNeedLoginUrl", (Object)notLoginConf);
        confJson.put("conf:loginUrlConf", (Object)urlConf);
        return confJson.getJSONObject(key);
    }

    @Override
    public MtopResult getSessionResult(MtopData mtopData) {
        Long userId;
        MtopResult result = new MtopResult();
        String key = MtopDataSourceImpl.getSessionKey(mtopData.getSource(), mtopData.getDomain(), mtopData.getSessionId());
        String value = this.getSession(key);
        if (value == null) {
            return result;
        }
        JSONObject sessionObj = JSONObject.parseObject((String)value);
        String token = sessionObj.getString("token");
        if (token != null) {
            result.setToken(token);
        }
        if ((userId = sessionObj.getLong("userId")) != null) {
            result.setUserId(userId);
        }
        return result;
    }

    private Boolean projectNeedVerify(String projectId) {
        return false;
    }

    public static String getSessionKey(String source, String domain, String sessionId) {
        String shortS = SourceCode.getShortSource((String)source);
        StringBuilder sb = new StringBuilder(domain);
        sb.append(StrSplit.M);
        if (shortS != null) {
            sb.append(shortS).append(StrSplit.M);
        }
        sb.append(sessionId);
        return sb.toString();
    }

    public String getSession(String key) {
        try {
            DBQuery sessionDbQuery = new DBQuery();
            sessionDbQuery.setTable("lowcode_uic_session");
            sessionDbQuery.setSelectOne(Boolean.valueOf(true));
            sessionDbQuery.setCamelCase(Boolean.valueOf(true));
            sessionDbQuery.setUpperOrLowerCase("lowerCase");
            HashMap<String, String> projectConfConditionMap = new HashMap<String, String>();
            projectConfConditionMap.put("id", key);
            sessionDbQuery.setConditionMap(projectConfConditionMap);
            JSONObject session = (JSONObject)this.dbReadUtil.find(sessionDbQuery);
            if (session == null) {
                return null;
            }
            return session.getString("content");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public boolean isNeedLogin(HttpServletRequest request) {
        int index;
        String substring;
        String[] split;
        String projectIdStr;
        if (request.getMethod().equals("OPTIONS")) {
            return false;
        }
        String url = request.getRequestURI();
        String projectId = request.getParameter("lowcodeProjectId");
        if (StringUtil.isBlank((String)projectId) && url.indexOf("/modularity/project") != -1 && NumberUtils.isNumber((String)(projectIdStr = (split = (substring = url.substring(index = url.indexOf("modularity/project")).replaceFirst("modularity/project", "")).split("/"))[0].trim()))) {
            projectId = projectIdStr;
        }
        if (!this.projectNeedVerify(projectId).booleanValue()) {
            return false;
        }
        if (this.isFilterUrl(request)) {
            return false;
        }
        JSONObject conf = this.getUrlConf("conf:loginUrlConf");
        JSONObject urlMap = conf.getJSONObject("notNeedLoginUrl");
        if (url.contains("/biz/customizeModule.do")) {
            String code = request.getParameter("lowcodeModule");
            StringBuilder sb = new StringBuilder(url);
            sb.append("?lowcodeModule=").append(code);
            url = sb.toString();
        }
        if (urlMap == null || urlMap.size() == 0) {
            return true;
        }
        return urlMap.get((Object)url) == null;
    }

    private boolean isFilterUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (url.contains("/biz/image/") || url.contains("/server-static/")) {
            return true;
        }
        return "/biz/register,/biz/login,/biz/license.do".contains(url);
    }
}

