/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.http.webservice;

import com.manatee.common.util.tool.core.exceptions.UtilException;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.XmlUtil;
import com.manatee.common.util.tool.http.webservice.SoapClient;
import com.manatee.common.util.tool.http.webservice.SoapProtocol;
import com.manatee.common.util.tool.http.webservice.SoapRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SoapUtil {
    public static SoapClient createClient(String url) {
        return SoapClient.create(url);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol) {
        return SoapClient.create(url, protocol);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol, String namespaceURI) {
        return SoapClient.create(url, protocol, namespaceURI);
    }

    public static String toString(SOAPMessage message, boolean pretty) {
        return SoapUtil.toString(message, pretty, CharsetUtil.CHARSET_UTF_8);
    }

    public static String toString(SOAPMessage message, boolean pretty, Charset charset) {
        String messageToString;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
        }
        catch (IOException | SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        try {
            messageToString = out.toString(charset.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
        return pretty ? XmlUtil.format(messageToString) : messageToString;
    }
}

