/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.http.ssl;

import com.manatee.common.util.tool.core.net.SSLContextBuilder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLSocketFactoryBuilder {
    public static final String SSL = "SSL";
    public static final String SSLv2 = "SSLv2";
    public static final String SSLv3 = "SSLv3";
    public static final String TLS = "TLS";
    public static final String TLSv1 = "TLSv1";
    public static final String TLSv11 = "TLSv1.1";
    public static final String TLSv12 = "TLSv1.2";
    SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();

    public static SSLSocketFactoryBuilder create() {
        return new SSLSocketFactoryBuilder();
    }

    public SSLSocketFactoryBuilder setProtocol(String protocol) {
        this.sslContextBuilder.setProtocol(protocol);
        return this;
    }

    public SSLSocketFactoryBuilder setTrustManagers(TrustManager ... trustManagers) {
        this.sslContextBuilder.setTrustManagers(trustManagers);
        return this;
    }

    public SSLSocketFactoryBuilder setKeyManagers(KeyManager ... keyManagers) {
        this.sslContextBuilder.setKeyManagers(keyManagers);
        return this;
    }

    public SSLSocketFactoryBuilder setSecureRandom(SecureRandom secureRandom) {
        this.sslContextBuilder.setSecureRandom(secureRandom);
        return this;
    }

    public SSLSocketFactory build() throws NoSuchAlgorithmException, KeyManagementException {
        return this.sslContextBuilder.build().getSocketFactory();
    }
}

