/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.crypto;

import com.manatee.common.util.tool.core.io.IORuntimeException;
import com.manatee.common.util.tool.crypto.BCUtil;
import com.manatee.common.util.tool.crypto.CryptoException;
import com.manatee.common.util.tool.crypto.asymmetric.SM2;
import com.manatee.common.util.tool.crypto.digest.HMac;
import com.manatee.common.util.tool.crypto.digest.HmacAlgorithm;
import com.manatee.common.util.tool.crypto.digest.SM3;
import com.manatee.common.util.tool.crypto.digest.mac.BCHMacEngine;
import com.manatee.common.util.tool.crypto.digest.mac.MacEngine;
import com.manatee.common.util.tool.crypto.symmetric.SM4;
import com.manatee.common.util.tool.crypto.symmetric.SymmetricCrypto;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SmUtil {
    public static final String SM2_CURVE_NAME = "sm2p256v1";
    public static final ECDomainParameters SM2_DOMAIN_PARAMS = BCUtil.toDomainParams(GMNamedCurves.getByName((String)"sm2p256v1"));
    private static final int RS_LEN = 32;

    public static SM2 sm2() {
        return new SM2();
    }

    public static SM2 sm2(String privateKeyStr, String publicKeyStr) {
        return new SM2(privateKeyStr, publicKeyStr);
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static SM3 sm3() {
        return new SM3();
    }

    public static String sm3(String data) {
        return SmUtil.sm3().digestHex(data);
    }

    public static String sm3(InputStream data) {
        return SmUtil.sm3().digestHex(data);
    }

    public static String sm3(File dataFile) {
        return SmUtil.sm3().digestHex(dataFile);
    }

    public static SM4 sm4() {
        return new SM4();
    }

    public static SymmetricCrypto sm4(byte[] key) {
        return new SM4(key);
    }

    public static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    public static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }

    public static byte[] rsAsn1ToPlain(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = SmUtil.bigIntToFixedLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = SmUtil.bigIntToFixedLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    public static byte[] rsPlainToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new CryptoException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static MacEngine createHmacSm3Engine(byte[] key) {
        return new BCHMacEngine((Digest)new SM3Digest(), key);
    }

    public static HMac hmacSm3(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSM3, key);
    }

    private static byte[] bigIntToFixedLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new CryptoException("Error rs: {}", Hex.toHexString((byte[])rs));
    }
}

