/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.bloomfilter;

import com.manatee.common.util.tool.bloomfilter.BloomFilter;
import com.manatee.common.util.tool.bloomfilter.filter.DefaultFilter;
import com.manatee.common.util.tool.bloomfilter.filter.ELFFilter;
import com.manatee.common.util.tool.bloomfilter.filter.JSFilter;
import com.manatee.common.util.tool.bloomfilter.filter.PJWFilter;
import com.manatee.common.util.tool.bloomfilter.filter.SDBMFilter;
import com.manatee.common.util.tool.core.util.NumberUtil;

public class BitMapBloomFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private BloomFilter[] filters;

    public BitMapBloomFilter(int m) {
        long mNum = NumberUtil.div(String.valueOf(m), String.valueOf(5)).longValue();
        long size = mNum * 1024L * 1024L * 8L;
        this.filters = new BloomFilter[]{new DefaultFilter(size), new ELFFilter(size), new JSFilter(size), new PJWFilter(size), new SDBMFilter(size)};
    }

    public BitMapBloomFilter(int m, BloomFilter ... filters) {
        this(m);
        this.filters = filters;
    }

    @Override
    public boolean add(String str) {
        boolean flag = false;
        for (BloomFilter filter : this.filters) {
            flag |= filter.add(str);
        }
        return flag;
    }

    @Override
    public boolean contains(String str) {
        for (BloomFilter filter : this.filters) {
            if (filter.contains(str)) continue;
            return false;
        }
        return true;
    }
}

