/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.net;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.net.MaskBit;
import com.manatee.fun.domain.StrSplit;

public class Ipv4Util {
    public static final String IP_SPLIT_MARK = "-";
    public static final String IP_MASK_SPLIT_MARK = "/";
    public static final int IP_MASK_MAX = 32;

    public static String formatIpBlock(String ip, String mask) {
        return ip + IP_MASK_SPLIT_MARK + Ipv4Util.getMaskBitByMask(mask);
    }

    public static String longToIpv4(long longIP) {
        StringBuilder sb = new StringBuilder();
        sb.append(longIP >> 24 & 0xFFL);
        sb.append(StrSplit.PA);
        sb.append(longIP >> 16 & 0xFFL);
        sb.append(StrSplit.PA);
        sb.append(longIP >> 8 & 0xFFL);
        sb.append(StrSplit.PA);
        sb.append(longIP & 0xFFL);
        return sb.toString();
    }

    public static int getMaskBitByMask(String mask) {
        String[] split;
        int inetmask = 0;
        for (String part : split = StringUtil.isBlank(mask) ? new String[]{} : mask.split(StrSplit.PA)) {
            StringBuffer sbf = Ipv4Util.toBin(Integer.parseInt(part));
            String str = sbf.reverse().toString();
            int count = 0;
            for (int i = 0; i < str.length() && (i = str.indexOf(49, i)) != -1; ++i) {
                ++count;
            }
            inetmask += count;
        }
        return inetmask;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        if (!(isAll || maskBit > 0 && maskBit < 32)) {
            return 0;
        }
        int count = (int)Math.pow(2.0, 32 - maskBit);
        return isAll ? count : count - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        return MaskBit.get(maskBit);
    }

    private static StringBuffer toBin(int x) {
        StringBuffer result = new StringBuffer();
        result.append(x % 2);
        x /= 2;
        while (x > 0) {
            result.append(x % 2);
            x /= 2;
        }
        return result;
    }
}

