/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.exception.BizException;
import com.manatee.process.domain.ProcessContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CloneUtil {
    public static ProcessContent getCloneProcessContent(ProcessContent originalContent) throws BizException {
        ProcessContent cloneContent;
        InputStream file = originalContent.getFile();
        if (file != null) {
            InputStream cloneFile = CloneUtil.getCloneInputStream(file);
            originalContent.setFile(null);
            originalContent.removeTempContent("file");
            cloneContent = CloneUtil.cloneByStream(originalContent);
            originalContent.setFile(cloneFile);
            originalContent.putTempContent("file", cloneFile);
            cloneContent.setFile(cloneFile);
            cloneContent.putTempContent("file", cloneFile);
        } else {
            cloneContent = CloneUtil.cloneByStream(originalContent);
        }
        return cloneContent;
    }

    public static <T> T cloneByStream(T obj) throws BizException {
        Object object;
        if (!(obj instanceof Serializable)) {
            return null;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            out.flush();
            in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            object = in.readObject();
        }
        catch (Exception e) {
            throw new BizException(e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return (T)object;
    }

    private static InputStream getCloneInputStream(InputStream originalInputStream) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = originalInputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream cloneInputStream = new ByteArrayInputStream(bytes);
            originalInputStream = new ByteArrayInputStream(bytes);
            return cloneInputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

