/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.util;

import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.manatee.lowcode.util.CacheRamUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;

public class ProgressRowWriteHandler
implements RowWriteHandler {
    private int totalCount;
    private int writtenRows = 0;
    private String cacheKey;
    private int cacheTime;
    private int progressCount;
    private String fileName;
    private CacheRamUtil cacheRamUtil;

    public ProgressRowWriteHandler(CacheRamUtil cacheRamUtil, String cacheKey, int cacheTime, int totalCount, int progressCount, String fileName) {
        this.cacheRamUtil = cacheRamUtil;
        this.cacheKey = cacheKey;
        this.cacheTime = cacheTime;
        this.totalCount = totalCount;
        this.progressCount = progressCount;
        this.fileName = fileName;
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        ++this.writtenRows;
        if (StringUtils.isBlank((CharSequence)this.cacheKey)) {
            return;
        }
        HashMap<String, Object> progressInfo = new HashMap<String, Object>(4);
        progressInfo.put("fileName", this.fileName);
        progressInfo.put("completedSize", this.writtenRows);
        progressInfo.put("totalSize", this.totalCount);
        if (this.writtenRows == 1) {
            progressInfo.put("rate", "0%");
            this.cacheRamUtil.setCache(this.cacheKey, progressInfo, Long.valueOf((long)this.cacheTime * 1L));
        } else if (this.writtenRows >= this.totalCount) {
            progressInfo.put("rate", "100%");
            this.cacheRamUtil.setCache(this.cacheKey, progressInfo, Long.valueOf((long)this.cacheTime * 1L));
        } else if (this.writtenRows % this.progressCount == 0) {
            float progress = (float)this.writtenRows / (float)this.totalCount * 100.0f;
            String result = String.format("%.2f", Float.valueOf(progress)) + "%";
            progressInfo.put("rate", result);
            this.cacheRamUtil.setCache(this.cacheKey, progressInfo, Long.valueOf((long)this.cacheTime * 1L));
        }
    }
}

