/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.manatee.excel.domain.QueryExcel;
import com.manatee.excel.domain.SheetDataMap;
import com.manatee.excel.read.DataListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;

public class ExcelReadUtil {
    public static List<Map<String, Object>> readExcelMap(QueryExcel query) {
        ArrayList<Map<String, Object>> listValues = new ArrayList<Map<String, Object>>();
        List<Object> data = ExcelReadUtil.readFile(query);
        for (int i = 0; i < data.size(); ++i) {
            List value = (List)data.get(i);
            Map<String, Object> newValue = ExcelReadUtil.readConf(query, value);
            if (newValue == null) continue;
            listValues.add(newValue);
        }
        return listValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SheetDataMap readSheets(QueryExcel query) {
        SheetDataMap sheetDataMap = new SheetDataMap();
        InputStream inputStream = null;
        ExcelReader excelReader = null;
        try {
            inputStream = query.getFile();
            excelReader = EasyExcel.read((InputStream)inputStream).build();
            List<ReadSheet> readSheetList = ExcelReadUtil.readSheetList(query, sheetDataMap);
            excelReader.read(readSheetList);
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException readSheetList) {}
            if (excelReader != null) {
                excelReader.finish();
            }
        }
        return sheetDataMap;
    }

    private static List<ReadSheet> readSheetList(QueryExcel query, SheetDataMap sheetDataMap) {
        ArrayList<ReadSheet> readSheetList;
        block4: {
            List<Integer> sheetNos;
            block3: {
                readSheetList = new ArrayList<ReadSheet>();
                List<String> sheetNames = query.getSheetName();
                sheetNos = query.getSheetNo();
                if (sheetNames != null && sheetNames.size() != 0) {
                    sheetDataMap.setHasSheetName(true);
                }
                if (sheetNames == null) break block3;
                for (String sheetName : sheetNames) {
                    DataListener listener = new DataListener();
                    listener.setSheetDataMap(sheetDataMap);
                    ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)sheetName).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)listener)).build();
                    readSheetList.add(readSheet);
                }
                break block4;
            }
            if (sheetNos == null) break block4;
            for (Integer num : sheetNos) {
                DataListener listener = new DataListener();
                listener.setSheetDataMap(sheetDataMap);
                ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)num).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)listener)).build();
                readSheetList.add(readSheet);
            }
        }
        return readSheetList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> readFile(QueryExcel query) {
        ArrayList<Object> listValues = new ArrayList();
        InputStream inputStream = null;
        try {
            inputStream = query.getFile();
            listValues = ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream).sheet().headRowNumber(Integer.valueOf(0))).doReadSync();
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return listValues;
    }

    private static Map<String, Object> readConf(QueryExcel query, List<String> value) {
        String columns = query.getColumns();
        String[] columnStrs = columns.split(",");
        String columnName = query.getColumnName();
        String[] columnNames = columnName.split(",");
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        HashedMap seatMap = new HashedMap();
        for (int j = 0; j < columnStrs.length; ++j) {
            Integer num = Integer.valueOf(columnStrs[j]);
            seatMap.put(num, num);
            String name = columnNames[j];
            String columnValue = value.get(num);
            valueMap.put(name, columnValue);
        }
        if (query.isIncludeAll()) {
            int index = 0;
            for (String aValue : value) {
                if (seatMap.get(index) != null) {
                    ++index;
                    continue;
                }
                valueMap.put(index + "", aValue);
                ++index;
            }
        }
        return valueMap;
    }

    private static List<String> readConfValue(String filter, String[] columnStrs, List<String> value) {
        ArrayList<String> newValue = new ArrayList<String>();
        for (int j = 0; j < columnStrs.length; ++j) {
            Integer num = Integer.valueOf(columnStrs[j]);
            String columnValue = value.get(num);
            newValue.add(columnValue);
        }
        return newValue;
    }

    public static InputStream geFileInputStream(String fileName) {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (Throwable var3) {
            var3.printStackTrace();
        }
        return in;
    }

    public static void main(String[] args) {
        QueryExcel query = new QueryExcel();
        ArrayList<String> sheetNames = new ArrayList<String>();
        sheetNames.add("Sheet1");
        sheetNames.add("Sheet2");
        query.setSheetName(sheetNames);
        String file = "/Users/ziyue/excel/taobao.xls";
        InputStream in = ExcelReadUtil.geFileInputStream(file);
        query.setFile(in);
        SheetDataMap map = ExcelReadUtil.readSheets(query);
        System.out.println("ok");
    }
}

