/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.exec.process;

import com.manatee.common.exception.BizException;
import com.manatee.exec.base.ScriptExecBasePlugin;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScriptExecProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(ScriptExecProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Autowired
    private Map<String, ScriptExecBasePlugin> pluginMap;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"scriptType"});
        this.processConfUtil.checkConf(content, new String[]{"script"});
        String scriptType = content.getStepConfString("scriptType");
        String script = this.variableUtil.calVarInConf(content, "script");
        try {
            ScriptExecBasePlugin scriptExecBasePlugin = this.pluginMap.get(scriptType);
            scriptExecBasePlugin.execScript(script);
        }
        catch (ScriptException e) {
            LOGGER.error("execScript error, scriptType:\u3010{}\u3011, script:\u3010{}\u3011, e:\u3010{}\u3011", new Object[]{scriptType, script, e});
            throw new BizException((Throwable)e);
        }
    }

    public String getName() {
        return "scriptExec";
    }
}

