CREATE TABLE `lowcode_logic_attribute` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL COMMENT '项目id',
  `logic_id` bigint(20) NOT NULL COMMENT '逻辑模型id',
  `attr_code` varchar(64) NOT NULL COMMENT '编码',
  `attr_remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `attr_type` varchar(64) DEFAULT NULL COMMENT '类型',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `create_user` bigint(20) DEFAULT NULL COMMENT '创建人',
  `gmt_create` datetime DEFAULT NULL  COMMENT '创建时间',
  `modified_user` bigint(20) DEFAULT NULL COMMENT '修改用户',
  `gmt_modified` datetime DEFAULT NULL COMMENT '修改时间',
  `valid` tinyint(4) DEFAULT 0 COMMENT '状态:-1 删除, 0 正常',
  `attr_class` tinyint(4) NULL DEFAULT 10 COMMENT '分类，10-基础类型，20-集合类型，21-集合对象，30-对象',
  `attr_nullable` tinyint(4) NULL DEFAULT 0 COMMENT '是否必填，1-必填，0-非必填',
  `attr_size` int(9) NULL DEFAULT 0 COMMENT '字段大小',
  `attr_pk` tinyint(4) NULL DEFAULT 0 COMMENT '是否主键，1-是，0-不是',
  `attr_pk_create_method` tinyint(4) NULL DEFAULT 1 COMMENT '主键生成方式，1-自增，2-uuid',
  `attr_conf` text NULL COMMENT '字段配置',
  PRIMARY KEY (`id`),
  KEY `idx_logicId_code` (`logic_id`,`attr_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据模型-逻辑模型属性表';